/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.client.OAuth2AuthorizationContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.util.Assert;

public final class DelegatingOAuth2AuthorizedClientProvider
implements OAuth2AuthorizedClientProvider {
    private final List<OAuth2AuthorizedClientProvider> authorizedClientProviders;

    public DelegatingOAuth2AuthorizedClientProvider(OAuth2AuthorizedClientProvider ... authorizedClientProviders) {
        Assert.notEmpty((Object[])authorizedClientProviders, (String)"authorizedClientProviders cannot be empty");
        this.authorizedClientProviders = Collections.unmodifiableList(Arrays.asList(authorizedClientProviders));
    }

    public DelegatingOAuth2AuthorizedClientProvider(List<OAuth2AuthorizedClientProvider> authorizedClientProviders) {
        Assert.notEmpty(authorizedClientProviders, (String)"authorizedClientProviders cannot be empty");
        this.authorizedClientProviders = Collections.unmodifiableList(new ArrayList<OAuth2AuthorizedClientProvider>(authorizedClientProviders));
    }

    @Override
    @Nullable
    public OAuth2AuthorizedClient authorize(OAuth2AuthorizationContext context) {
        Assert.notNull((Object)context, (String)"context cannot be null");
        for (OAuth2AuthorizedClientProvider authorizedClientProvider : this.authorizedClientProviders) {
            OAuth2AuthorizedClient oauth2AuthorizedClient = authorizedClientProvider.authorize(context);
            if (oauth2AuthorizedClient == null) continue;
            return oauth2AuthorizedClient;
        }
        return null;
    }
}

