/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

final class X509CertificateThumbprintValidator
implements OAuth2TokenValidator<Jwt> {
    static final Supplier<X509Certificate> DEFAULT_X509_CERTIFICATE_SUPPLIER = new DefaultX509CertificateSupplier();
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Supplier<X509Certificate> x509CertificateSupplier;

    X509CertificateThumbprintValidator(Supplier<X509Certificate> x509CertificateSupplier) {
        Assert.notNull(x509CertificateSupplier, (String)"x509CertificateSupplier cannot be null");
        this.x509CertificateSupplier = x509CertificateSupplier;
    }

    public OAuth2TokenValidatorResult validate(Jwt jwt) {
        String x509CertificateThumbprint;
        Map confirmationMethodClaim = (Map)jwt.getClaim("cnf");
        String x509CertificateThumbprintClaim = null;
        if (!CollectionUtils.isEmpty((Map)confirmationMethodClaim) && confirmationMethodClaim.containsKey("x5t#S256")) {
            x509CertificateThumbprintClaim = (String)confirmationMethodClaim.get("x5t#S256");
        }
        if (x509CertificateThumbprintClaim == null) {
            return OAuth2TokenValidatorResult.success();
        }
        X509Certificate x509Certificate = this.x509CertificateSupplier.get();
        if (x509Certificate == null) {
            OAuth2Error error = new OAuth2Error("invalid_token", "Unable to obtain X509Certificate from current request.", null);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)error.toString());
            }
            return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{error});
        }
        try {
            x509CertificateThumbprint = X509CertificateThumbprintValidator.computeSHA256Thumbprint(x509Certificate);
        }
        catch (Exception ex) {
            OAuth2Error error = new OAuth2Error("invalid_token", "Failed to compute SHA-256 Thumbprint for X509Certificate.", null);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)error.toString());
            }
            return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{error});
        }
        if (!x509CertificateThumbprint.equals(x509CertificateThumbprintClaim)) {
            OAuth2Error error = new OAuth2Error("invalid_token", "Invalid SHA-256 Thumbprint for X509Certificate.", null);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)error.toString());
            }
            return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{error});
        }
        return OAuth2TokenValidatorResult.success();
    }

    static String computeSHA256Thumbprint(X509Certificate x509Certificate) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] digest = md.digest(x509Certificate.getEncoded());
        return Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
    }

    private static final class DefaultX509CertificateSupplier
    implements Supplier<X509Certificate> {
        private DefaultX509CertificateSupplier() {
        }

        @Override
        public X509Certificate get() {
            RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
            if (requestAttributes == null) {
                return null;
            }
            X509Certificate[] clientCertificateChain = (X509Certificate[])requestAttributes.getAttribute("jakarta.servlet.request.X509Certificate", 0);
            return clientCertificateChain != null && clientCertificateChain.length > 0 ? clientCertificateChain[0] : null;
        }
    }
}

