/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.regex.Pattern;

public class PemUtils {
    private static byte[] parsePEMFile(File file) {
        FileInputStream fileInputStream = new FileInputStream(file);
        String string = new String(PemUtils.readAllBytes(fileInputStream), StandardCharsets.ISO_8859_1);
        Pattern pattern = Pattern.compile("(?m)(?s)^---*BEGIN.*---*$(.*)^---*END.*---*$.*");
        String string2 = pattern.matcher(string).replaceFirst("$1");
        return Base64.getMimeDecoder().decode(string2);
    }

    private static byte[] readAllBytes(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n2 = 0;
        while (n2 != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
            n2 = inputStream.read(byArray);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static PublicKey getPublicKey(byte[] byArray, String string) {
        PublicKey publicKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println("Could not reconstruct the public key, the given algorithm could not be found.");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            System.out.println("Could not reconstruct the public key");
        }
        return publicKey;
    }

    private static PrivateKey getPrivateKey(byte[] byArray, String string) {
        PrivateKey privateKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println("Could not reconstruct the private key, the given algorithm could not be found.");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            System.out.println("Could not reconstruct the private key");
        }
        return privateKey;
    }

    public static PublicKey readPublicKeyFromFile(String string, String string2) {
        byte[] byArray = PemUtils.parsePEMFile(new File(string));
        return PemUtils.getPublicKey(byArray, string2);
    }

    public static PrivateKey readPrivateKeyFromFile(String string, String string2) {
        byte[] byArray = PemUtils.parsePEMFile(new File(string));
        return PemUtils.getPrivateKey(byArray, string2);
    }
}

