/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.server.backend.rdf.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.derivo.semspect.server.backend.rdf.configuration.SemStoreConfiguration;
import de.derivo.semspect.server.backend.rdf.configuration.SemStoreManagedConfiguration;
import de.derivo.semspect.server.backend.rdf.configuration.StartupMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="semspect.rdf")
public class SemStoresConfiguration {
    private List<SemStoreConfiguration> databases = new ArrayList<SemStoreConfiguration>();
    private SemStoreManagedConfiguration managed = new SemStoreManagedConfiguration();
    private boolean terminateOnInitializationError = false;

    public List<SemStoreConfiguration> getDatabases() {
        return this.databases;
    }

    public SemStoresConfiguration setDatabases(List<SemStoreConfiguration> list) {
        this.databases = list;
        return this;
    }

    public SemStoreManagedConfiguration getManaged() {
        return this.managed;
    }

    public SemStoresConfiguration setManaged(SemStoreManagedConfiguration semStoreManagedConfiguration) {
        this.managed = semStoreManagedConfiguration;
        return this;
    }

    public boolean isTerminateOnInitializationError() {
        return this.terminateOnInitializationError;
    }

    public void setTerminateOnInitializationError(boolean bl2) {
        this.terminateOnInitializationError = bl2;
    }

    @JsonIgnore
    public Optional<SemStoreConfiguration> getSmartModeDBIfExistent() {
        return this.getDatabases().stream().filter(semStoreConfiguration -> semStoreConfiguration.getDatabase().equals("default-db")).findFirst();
    }

    @JsonIgnore
    public boolean isSmartMode() {
        return this.getDatabases().stream().anyMatch(semStoreConfiguration -> {
            String string = semStoreConfiguration.getMode();
            return string == null || string.toLowerCase().contains(StartupMode.SMART.name().toLowerCase());
        });
    }
}

