/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.server.extensions.cmem;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import de.derivo.semspect.server.core.a;
import de.derivo.semspect.server.extensions.cmem.a.d;
import de.derivo.semspect.server.extensions.cmem.a.f;
import de.derivo.semspect.server.extensions.cmem.b;
import de.derivo.semspect.server.extensions.cmem.c;
import de.derivo.semspect.server.view.rest.ServerConfiguration;
import de.derivo.semspect.server.view.rest.e.l;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.resource.IssuerUriCondition;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.AuthorizedClientServiceOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.reactive.function.client.ServletOAuth2AuthorizedClientExchangeFilterFunction;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoders;
import org.springframework.security.oauth2.jwt.JwtIssuerValidator;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
@EnableWebSecurity
@Conditional(value={b.class})
@de.derivo.utils.obfuscation.a
public class WebConfiguration {
    public static final String SEMSPECT_SERVICE_CLIENT = "semspect-service";
    @Autowired
    private ServerConfiguration serverConfiguration;
    @Autowired
    private OAuth2ResourceServerProperties resourceServerProperties;

    @Bean
    @Order(value=1)
    public SecurityFilterChain apiSecurity(HttpSecurity httpSecurity) {
        httpSecurity.securityMatcher(new String[]{"/api/**"}).authorizeHttpRequests(authorizationManagerRequestMatcherRegistry -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry.anyRequest()).authenticated()).oauth2ResourceServer(oAuth2ResourceServerConfigurer -> oAuth2ResourceServerConfigurer.jwt(Customizer.withDefaults()));
        return (SecurityFilterChain)l.a(httpSecurity, this.serverConfiguration).build();
    }

    @Bean
    @Order(value=2)
    public SecurityFilterChain frontendSecurity(HttpSecurity httpSecurity, f f2) {
        httpSecurity.authorizeHttpRequests(authorizationManagerRequestMatcherRegistry -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry.requestMatchers(new String[]{"/login**", "/error"})).permitAll().anyRequest()).authenticated()).oauth2Login(Customizer.withDefaults()).oidcLogout(oidcLogoutConfigurer -> oidcLogoutConfigurer.backChannel(Customizer.withDefaults()));
        return (SecurityFilterChain)l.a(httpSecurity, this.serverConfiguration).build();
    }

    @Bean
    @Qualifier(value="UserRequestsJWT")
    WebClient webClientUserRequestsJWT(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientRepository oAuth2AuthorizedClientRepository) {
        return WebClient.builder().filter((clientRequest, exchangeFunction) -> {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication instanceof JwtAuthenticationToken) {
                String string = ((Jwt)((JwtAuthenticationToken)authentication).getToken()).getTokenValue();
                ClientRequest clientRequest2 = ClientRequest.from((ClientRequest)clientRequest).header("Authorization", new String[]{"Bearer " + string}).build();
                return exchangeFunction.exchange(clientRequest2);
            }
            return exchangeFunction.exchange(clientRequest);
        }).build();
    }

    @Bean
    @Qualifier(value="UserRequestsOAuth2Login")
    WebClient userRequestsOAuth2Login(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientRepository oAuth2AuthorizedClientRepository) {
        ServletOAuth2AuthorizedClientExchangeFilterFunction servletOAuth2AuthorizedClientExchangeFilterFunction = new ServletOAuth2AuthorizedClientExchangeFilterFunction(clientRegistrationRepository, oAuth2AuthorizedClientRepository);
        servletOAuth2AuthorizedClientExchangeFilterFunction.setDefaultOAuth2AuthorizedClient(true);
        return WebClient.builder().apply(servletOAuth2AuthorizedClientExchangeFilterFunction.oauth2Configuration()).build();
    }

    @Bean
    @Qualifier(value="ServiceRequests")
    WebClient webClientServiceRequestsRequests(OAuth2AuthorizedClientService oAuth2AuthorizedClientService, ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientRepository oAuth2AuthorizedClientRepository) {
        OAuth2AuthorizedClientProvider oAuth2AuthorizedClientProvider = OAuth2AuthorizedClientProviderBuilder.builder().refreshToken().clientCredentials().build();
        AuthorizedClientServiceOAuth2AuthorizedClientManager authorizedClientServiceOAuth2AuthorizedClientManager = new AuthorizedClientServiceOAuth2AuthorizedClientManager(clientRegistrationRepository, oAuth2AuthorizedClientService);
        authorizedClientServiceOAuth2AuthorizedClientManager.setAuthorizedClientProvider(oAuth2AuthorizedClientProvider);
        ServletOAuth2AuthorizedClientExchangeFilterFunction servletOAuth2AuthorizedClientExchangeFilterFunction = new ServletOAuth2AuthorizedClientExchangeFilterFunction((OAuth2AuthorizedClientManager)authorizedClientServiceOAuth2AuthorizedClientManager);
        servletOAuth2AuthorizedClientExchangeFilterFunction.setDefaultClientRegistrationId(SEMSPECT_SERVICE_CLIENT);
        return WebClient.builder().filter((ExchangeFilterFunction)servletOAuth2AuthorizedClientExchangeFilterFunction).build();
    }

    @Bean
    public static f createUserAuthorization(@Value(value="${semspect.extension.cmem.authorization.cacheDuration:60}") long l2, d d2) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().expireAfterWrite(l2, TimeUnit.SECONDS);
        if (a.Cl) {
            cacheBuilder.recordStats();
        }
        return new f((Cache<de.derivo.semspect.server.extensions.cmem.a.b, Boolean>)cacheBuilder.build(), d2, null);
    }

    @Bean
    @ConditionalOnProperty(name={"spring.security.oauth2.resourceserver.jwt.jwk-set-uri"})
    public JwtDecoder jwtDecoderByJwkKeySetUri() {
        NimbusJwtDecoder nimbusJwtDecoder = NimbusJwtDecoder.withJwkSetUri((String)this.resourceServerProperties.getJwt().getJwkSetUri()).build();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = this.resourceServerProperties.getJwt().getIssuerUri();
        String string2 = "preferred_username";
        String string3 = "clientId";
        arrayList.add(new JwtTimestampValidator());
        if (string != null) {
            arrayList.add(new JwtIssuerValidator(string));
        }
        nimbusJwtDecoder.setJwtValidator((OAuth2TokenValidator)new DelegatingOAuth2TokenValidator(arrayList));
        nimbusJwtDecoder.setClaimSetConverter((Converter)new c(string2, string3));
        return nimbusJwtDecoder;
    }

    @Bean
    @Conditional(value={IssuerUriCondition.class})
    public JwtDecoder jwtDecoderByIssuerUri() {
        NimbusJwtDecoder nimbusJwtDecoder = (NimbusJwtDecoder)JwtDecoders.fromOidcIssuerLocation((String)this.resourceServerProperties.getJwt().getIssuerUri());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = "preferred_username";
        String string2 = "clientId";
        arrayList.add(new JwtTimestampValidator());
        arrayList.add(new JwtIssuerValidator(this.resourceServerProperties.getJwt().getIssuerUri()));
        nimbusJwtDecoder.setJwtValidator((OAuth2TokenValidator)new DelegatingOAuth2TokenValidator(arrayList));
        nimbusJwtDecoder.setClaimSetConverter((Converter)new c(string, string2));
        return nimbusJwtDecoder;
    }
}

