/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.server.view.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.derivo.semspect.server.view.rest.model.FiltersInner;
import de.derivo.semspect.server.view.rest.model.TreeStateExpansion;
import de.derivo.semspect.server.view.rest.model.TreeStateNode$TypeEnum;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.lang.Nullable;

@Schema(name="TreeStateNode", description="To obtain the results of an action (restriction to a category, complex filtering, expansion) on a node, we provide the tree from the first object found on the rootline while going up the tree or the root node if no object is found. Except for the root expansion, this tree will not contain any expansion from objects as their results can not be affected by any operation (they may have to be discarded if the node disappears, but that is a frontend task). We need only the rootline down to the modified node but the complete subtree starting at this node. ")
public class TreeStateNode {
    @Nullable
    private String id;
    @Nullable
    private TreeStateNode$TypeEnum type;
    @Valid
    @Nullable
    private List<List<String>> categoryIds;
    @Valid
    @Nullable
    private List<List<List<String>>> excludeCategoryIds;
    @Valid
    @Nullable
    private List<String> objectIds;
    @Valid
    @Nullable
    private List<FiltersInner> filter;
    @Valid
    @Nullable
    private @Valid List<@Valid TreeStateExpansion> expansions;
    @Nullable
    private String predecessorObject;
    @Nullable
    private String note;

    public TreeStateNode id(@Nullable String string) {
        this.id = string;
        return this;
    }

    @Schema(name="id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nullable String string) {
        this.id = string;
    }

    public TreeStateNode type(@Nullable TreeStateNode$TypeEnum typeEnum) {
        this.type = typeEnum;
        return this;
    }

    @Schema(name="type", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="type")
    @Nullable
    public TreeStateNode$TypeEnum getType() {
        return this.type;
    }

    public void setType(@Nullable TreeStateNode$TypeEnum typeEnum) {
        this.type = typeEnum;
    }

    public TreeStateNode categoryIds(@Nullable List<List<String>> list) {
        this.categoryIds = list;
        return this;
    }

    public TreeStateNode addCategoryIdsItem(List<String> list) {
        if (this.categoryIds == null) {
            this.categoryIds = new ArrayList<List<String>>();
        }
        this.categoryIds.add(list);
        return this;
    }

    @Valid
    @Schema(name="categoryIds", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="categoryIds")
    @Nullable
    public List<List<String>> getCategoryIds() {
        return this.categoryIds;
    }

    public void setCategoryIds(@Nullable List<List<String>> list) {
        this.categoryIds = list;
    }

    public TreeStateNode excludeCategoryIds(@Nullable List<List<List<String>>> list) {
        this.excludeCategoryIds = list;
        return this;
    }

    public TreeStateNode addExcludeCategoryIdsItem(List<List<String>> list) {
        if (this.excludeCategoryIds == null) {
            this.excludeCategoryIds = new ArrayList<List<List<String>>>();
        }
        this.excludeCategoryIds.add(list);
        return this;
    }

    @Valid
    @Schema(name="excludeCategoryIds", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="excludeCategoryIds")
    @Nullable
    public List<List<List<String>>> getExcludeCategoryIds() {
        return this.excludeCategoryIds;
    }

    public void setExcludeCategoryIds(@Nullable List<List<List<String>>> list) {
        this.excludeCategoryIds = list;
    }

    public TreeStateNode objectIds(@Nullable List<String> list) {
        this.objectIds = list;
        return this;
    }

    public TreeStateNode addObjectIdsItem(String string) {
        if (this.objectIds == null) {
            this.objectIds = new ArrayList<String>();
        }
        this.objectIds.add(string);
        return this;
    }

    @Schema(name="objectIds", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="objectIds")
    @Nullable
    public List<String> getObjectIds() {
        return this.objectIds;
    }

    public void setObjectIds(@Nullable List<String> list) {
        this.objectIds = list;
    }

    public TreeStateNode filter(@Nullable List<FiltersInner> list) {
        this.filter = list;
        return this;
    }

    public TreeStateNode addFilterItem(FiltersInner filtersInner) {
        if (this.filter == null) {
            this.filter = new ArrayList<FiltersInner>();
        }
        this.filter.add(filtersInner);
        return this;
    }

    @Valid
    @Schema(name="filter", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="filter")
    @Nullable
    public List<FiltersInner> getFilter() {
        return this.filter;
    }

    public void setFilter(@Nullable List<FiltersInner> list) {
        this.filter = list;
    }

    public TreeStateNode expansions(@Nullable List<@Valid TreeStateExpansion> list) {
        this.expansions = list;
        return this;
    }

    public TreeStateNode addExpansionsItem(TreeStateExpansion treeStateExpansion) {
        if (this.expansions == null) {
            this.expansions = new ArrayList<TreeStateExpansion>();
        }
        this.expansions.add(treeStateExpansion);
        return this;
    }

    @Valid
    @Schema(name="expansions", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="expansions")
    @Nullable
    public @Valid List<@Valid TreeStateExpansion> getExpansions() {
        return this.expansions;
    }

    public void setExpansions(@Nullable List<@Valid TreeStateExpansion> list) {
        this.expansions = list;
    }

    public TreeStateNode predecessorObject(@Nullable String string) {
        this.predecessorObject = string;
        return this;
    }

    @Schema(name="predecessorObject", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="predecessorObject")
    @Nullable
    public String getPredecessorObject() {
        return this.predecessorObject;
    }

    public void setPredecessorObject(@Nullable String string) {
        this.predecessorObject = string;
    }

    public TreeStateNode note(@Nullable String string) {
        this.note = string;
        return this;
    }

    @Schema(name="note", description="User defined note of this node", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="note")
    @Nullable
    public String getNote() {
        return this.note;
    }

    public void setNote(@Nullable String string) {
        this.note = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TreeStateNode treeStateNode = (TreeStateNode)object;
        return Objects.equals(this.id, treeStateNode.id) && Objects.equals((Object)this.type, (Object)treeStateNode.type) && Objects.equals(this.categoryIds, treeStateNode.categoryIds) && Objects.equals(this.excludeCategoryIds, treeStateNode.excludeCategoryIds) && Objects.equals(this.objectIds, treeStateNode.objectIds) && Objects.equals(this.filter, treeStateNode.filter) && Objects.equals(this.expansions, treeStateNode.expansions) && Objects.equals(this.predecessorObject, treeStateNode.predecessorObject) && Objects.equals(this.note, treeStateNode.note);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.categoryIds, this.excludeCategoryIds, this.objectIds, this.filter, this.expansions, this.predecessorObject, this.note});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class TreeStateNode {\n");
        stringBuilder.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        stringBuilder.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        stringBuilder.append("    categoryIds: ").append(this.toIndentedString(this.categoryIds)).append("\n");
        stringBuilder.append("    excludeCategoryIds: ").append(this.toIndentedString(this.excludeCategoryIds)).append("\n");
        stringBuilder.append("    objectIds: ").append(this.toIndentedString(this.objectIds)).append("\n");
        stringBuilder.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        stringBuilder.append("    expansions: ").append(this.toIndentedString(this.expansions)).append("\n");
        stringBuilder.append("    predecessorObject: ").append(this.toIndentedString(this.predecessorObject)).append("\n");
        stringBuilder.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

