#!/bin/bash

# install directory is directory of this script by default
if [ -z "${SEMSPECT_HOME}" ]; then
    SEMSPECT_HOME=$(cd -- "$(dirname -- "${BASH_SOURCE[0]}")" &>/dev/null && pwd)
fi
source "$SEMSPECT_HOME/java-settings.sh"
MAIN_CLASS="de.derivo.semspect.server.app.rdfrest.SemSpectServerSmartMode"

if [ -z "${SEMSPECT_CONFIG_PATH}" ]; then
    SEMSPECT_CONFIG_PATH=$SEMSPECT_HOME/smart-config/semspect_config.yaml
fi

if [ -z "${SEMSTORE_CONFIG_PATH}" ]; then
    SEMSTORE_CONFIG_PATH=$SEMSPECT_HOME/smart-config/semstore_config.yaml
fi

if [ -z "${SEMSTORE_INDICES_DIR}" ]; then
    SEMSTORE_INDICES_DIR=$SEMSPECT_HOME/smart-indices/
fi

if [ -z "${SEMSPECT_CONFIGS_DIR}" ]; then
    SEMSPECT_CONFIGS_DIR=$SEMSPECT_HOME/smart-config/datasets/
fi

echo "==="
echo "Starting SemSpect in smart mode with configuration:"
echo "Java command path: $JAVA_PATH"
echo "Java class path: $CLASS_PATH"
echo "JDK options: $JDK_OPTIONS"
echo "Configuration path: $SEMSPECT_CONFIG_PATH"
echo "Dataset configurations path: $SEMSPECT_CONFIGS_DIR"
echo "Store configuration path: $SEMSTORE_CONFIG_PATH"
echo "Store indices path: $SEMSTORE_INDICES_DIR"
echo "==="

$JAVA_PATH \
    $JDK_OPTIONS \
    -Dde.derivo.semspect.server.configuration.path="$SEMSPECT_CONFIG_PATH" \
    -cp "$CLASS_PATH" \
    "$MAIN_CLASS" \
    --spring.config.additional-location="$SEMSTORE_CONFIG_PATH" \
    --indexedDatasetsDirectory="$SEMSTORE_INDICES_DIR" \
    --datasetConfigsDirectory="$SEMSPECT_CONFIGS_DIR" \
    "$@"
