/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.server.app.rdfrest;

import de.derivo.semspect.server.app.rdfrest.SemSpectServerSmartMode;
import de.derivo.semspect.server.backend.rdf.configuration.SmartModeCleanOption;
import de.derivo.semspect.server.view.rest.SemSpectServer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import picocli.CommandLine;

@CommandLine.Command(name="run", description={"Run the SemSpect Server."})
public class Run
implements Callable<Void> {
    @CommandLine.Parameters(arity="1..*", index="0..*", description={"RDF data sources. Supported input: filepath or url. \n"})
    private String[] rdfDataSource = new String[0];
    @CommandLine.Option(names={"--clean"}, description={"Option to delete the indices ('DATA', default), the dataset configuration files ('CONFIG'), or both ('ALL')"}, arity="0..1")
    private SmartModeCleanOption[] cleanOption = null;
    @CommandLine.ParentCommand
    private SemSpectServerSmartMode semSpectServerSmartMode;

    @Override
    public Void call() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("--semspect.rdf.databases[0].database=default-db");
        arrayList.add("--semspect.rdf.databases[0].mode=smart");
        arrayList.addAll(this.getRDFDumpSpringParameter(this.rdfDataSource));
        SmartModeCleanOption smartModeCleanOption = SmartModeCleanOption.NONE;
        if (this.cleanOption != null) {
            smartModeCleanOption = this.cleanOption.length == 0 ? SmartModeCleanOption.DATA : this.cleanOption[0];
        }
        arrayList.add("--semspect.rdf.databases[0].smart.cleanOption=" + String.valueOf((Object)smartModeCleanOption));
        this.semSpectServerSmartMode.getSpringConfigurationPath().ifPresent(file -> arrayList.add(String.format("--spring.config.additional-location=%s", file.getAbsolutePath())));
        arrayList.add(String.format("--semspect.rdf.databases[0].smart.indexedDatasetsDirectory=%s", this.semSpectServerSmartMode.getIndexedDatasetsDirectory()));
        arrayList.add(String.format("--semspect.rdf.databases[0].smart.datasetConfigurationsDirectory=%s", this.semSpectServerSmartMode.getDatasetConfigsDirectory()));
        SemSpectServer.main(arrayList.toArray(new String[0]));
        return null;
    }

    private List<String> getRDFDumpSpringParameter(String[] stringArray) {
        return Arrays.stream(stringArray).map(string -> String.format("--semspect.rdf.databases[0].indexing.rdfDataSources=%s", string)).collect(Collectors.toList());
    }
}

