/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.server.backend.rdf.configuration;

import de.derivo.semspect.server.backend.rdf.b;
import de.derivo.semspect.server.backend.rdf.configuration.AppConfigFactory;
import de.derivo.semspect.server.backend.rdf.configuration.DataSourceProvider;
import de.derivo.semspect.server.backend.rdf.configuration.SemStoreConfiguration;
import de.derivo.semspect.server.backend.rdf.configuration.SemStoreInitializer;
import de.derivo.semspect.server.backend.rdf.configuration.SemStoresConfiguration;
import de.derivo.semspect.server.backend.rdf.configuration.Util;
import de.derivo.semspect.server.backend.rdf.configuration.verifier.SemStoresConfigurationVerifier;
import de.derivo.semspect.server.backend.rdf.d.k;
import de.derivo.semspect.server.backend.rdf.e;
import de.derivo.semspect.server.backend.rdf.service.persistence.a;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.tinylog.Logger;

@Configuration
public class SemStoresInitializer {
    @Autowired
    private SemStoresConfiguration semStoresConfiguration;
    @Autowired
    private AppConfigFactory appConfigFactory;
    @Autowired
    private ConfigurableApplicationContext ctx;

    @Bean
    @Scope(value="singleton")
    e getSemSpectExploration() {
        this.setDefaultConfigPathsIfUndefinedForStartupMode();
        Util.checkConfiguration(this.ctx, new SemStoresConfigurationVerifier(this.semStoresConfiguration), true);
        List<b> list = this.loadDatabases(this.ctx);
        List<b> list2 = this.loadManagedDatabasesFromFileSystem();
        list.addAll(list2);
        return new e(list, this.semStoresConfiguration.getManaged());
    }

    @Bean
    public DataSourceProvider defaultDataSourceProvider() {
        return DataSourceProvider.DEFAULT;
    }

    private void setDefaultConfigPathsIfUndefinedForStartupMode() {
        Path path;
        if (this.semStoresConfiguration.isSmartMode()) {
            SemStoreConfiguration semStoreConfiguration = this.semStoresConfiguration.getSmartModeDBIfExistent().orElseThrow();
            path = SemStoreInitializer.getSmartModeConfigDir(semStoreConfiguration);
        } else {
            path = this.semStoresConfiguration.getManaged().getDatasetConfigurationsDirectoryAsPath().orElseThrow();
        }
        SemStoresInitializer.setJVMParamIfUndefined("de.derivo.semspect.server.data.path", k.n(path).toString());
        SemStoresInitializer.setJVMParamIfUndefined("de.derivo.semspect.server.configuration.category.path", k.aE(path).toString());
        SemStoresInitializer.setJVMParamIfUndefined("de.derivo.semspect.server.configuration.facets.path", k.l(path).toString());
        SemStoresInitializer.setJVMParamIfUndefined("de.derivo.semspect.server.configuration.dossier.path", k.m(path).toString());
    }

    private static void setJVMParamIfUndefined(String string, String string2) {
        Properties properties = System.getProperties();
        if (properties.get(string) == null) {
            properties.setProperty(string, string2);
        }
    }

    private static boolean checkIfJVMParameterIsSet(String string) {
        return System.getProperty(string) != null;
    }

    private List<b> loadDatabases(ConfigurableApplicationContext configurableApplicationContext) {
        ArrayList<b> arrayList = new ArrayList<b>();
        for (int i2 = 0; i2 < this.semStoresConfiguration.getDatabases().size(); ++i2) {
            SemStoreConfiguration semStoreConfiguration = this.semStoresConfiguration.getDatabases().get(i2);
            try {
                Logger.info((String)"Initializing database {}", (Object[])new Object[]{semStoreConfiguration.getDatabase()});
                SemStoreInitializer semStoreInitializer = SemStoreInitializer.create(i2, this.appConfigFactory.create(semStoreConfiguration), 0, this.semStoresConfiguration.getManaged().getIndicesDirectoryAsPath().orElse(null), new HashMap<String, Object>());
                arrayList.add(semStoreInitializer.getDatabase(configurableApplicationContext));
                continue;
            }
            catch (Throwable throwable) {
                Logger.error((String)"Error during initialization of database: {} \n\n{}", (Object[])new Object[]{semStoreConfiguration.getDatabase(), throwable.getMessage()});
                if (!this.semStoresConfiguration.isTerminateOnInitializationError()) continue;
                Util.exit(configurableApplicationContext, 1);
            }
        }
        return arrayList;
    }

    private List<b> loadManagedDatabasesFromFileSystem() {
        Path path = Paths.get(this.semStoresConfiguration.getManaged().getIndicesDirectory(), new String[0]);
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return new a(path).kC().stream().map(databaseSerialization -> {
            try {
                Logger.info((String)"Initializing database {}", (Object[])new Object[]{databaseSerialization.getSemStoreConfiguration().getDatabase()});
                SemStoreInitializer semStoreInitializer = SemStoreInitializer.create(-1, this.appConfigFactory.create(databaseSerialization.getSemStoreConfiguration()), databaseSerialization.getDataVersion(), path, databaseSerialization.getMetadata());
                return semStoreInitializer.getDatabase(this.ctx);
            }
            catch (Throwable throwable) {
                Logger.error((String)"Error during initialization of managed database: {} \n\n{}", (Object[])new Object[]{databaseSerialization.getSemStoreConfiguration().getDatabase(), throwable.getMessage()});
                if (this.semStoresConfiguration.isTerminateOnInitializationError()) {
                    Util.exit(this.ctx, 1);
                }
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

