/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.server.backend.rdf.configuration.verifier;

import de.derivo.semspect.server.backend.rdf.configuration.PresentationConfig;
import de.derivo.semspect.server.backend.rdf.configuration.SemStoreConfiguration;
import de.derivo.semspect.server.backend.rdf.configuration.SemStoreGenerationConfig;
import de.derivo.semspect.server.backend.rdf.configuration.SemStoreSmartModeConfig;
import de.derivo.semspect.server.backend.rdf.configuration.StartupMode;
import de.derivo.semspect.server.backend.rdf.configuration.verifier.DatabaseNameWhitelistVerifier;
import de.derivo.semspect.server.backend.rdf.configuration.verifier.RDFDataSourceVerifier;
import de.derivo.semspect.server.backend.rdf.configuration.verifier.SemStoreIndicesDirVerifier;
import de.derivo.semspect.server.backend.rdf.configuration.verifier.SemStoreStartupModeVerifier;
import de.derivo.semspect.server.core.b.N;
import de.derivo.semspect.server.core.d.i.a.a;
import de.derivo.semspect.server.core.d.i.a.c;
import de.derivo.semspect.server.core.d.i.a.e;
import de.derivo.semspect.server.core.d.i.a.f;
import de.derivo.semspect.server.core.d.i.a.j;
import de.derivo.semspect.server.core.d.i.a.l;
import de.derivo.semspect.server.core.d.i.a.p;
import de.derivo.semspect.server.core.d.i.a.q;
import de.derivo.semspect.server.core.d.i.a.v;
import de.derivo.semspect.server.core.d.i.a.x;
import de.derivo.semspect.server.core.d.i.a.y;
import de.derivo.semspect.server.core.d.i.b;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class SemStoreConfigurationVerifier
implements c {
    private final int configurationIndex;
    private final StartupMode startupModeInConfiguration;
    private final StartupMode validatePart;
    private final SemStoreConfiguration config;
    private final SemStoreGenerationConfig generationConfig;
    private final SemStoreSmartModeConfig smartModeConfig;
    private final PresentationConfig presentationConfig;

    public SemStoreConfigurationVerifier(int n2, StartupMode startupMode, StartupMode startupMode2, SemStoreConfiguration semStoreConfiguration) {
        this.configurationIndex = n2;
        this.startupModeInConfiguration = startupMode;
        this.validatePart = startupMode2;
        this.config = semStoreConfiguration;
        this.generationConfig = semStoreConfiguration.getIndexing();
        this.smartModeConfig = semStoreConfiguration.getSmart();
        this.presentationConfig = semStoreConfiguration.getPresentationConfig();
    }

    @Override
    public void verify() {
        switch (this.validatePart) {
            case GENERATE: {
                this.verifyGenerate();
                break;
            }
            case LOAD: {
                this.verifyLoad();
                break;
            }
            case SMART: {
                this.verifySmart();
                break;
            }
            default: {
                throw new N(this.validatePart);
            }
        }
        this.verifyPresentationConfig();
    }

    private void verifyPresentationConfig() {
        List<de.derivo.semspect.server.core.d.i.j<?>> list = this.createGeneralVerifiers();
        list.add(e.a(this.fieldName("title.locales"), this.presentationConfig.getLocales(), this.presentationConfig::getLocales, List.of(supplier -> new a<String>(((Supplier)supplier)::get, y::new))));
        list.add(e.a(this.fieldName("title.captionProperties"), this.presentationConfig.getCaptionProperties(), this.presentationConfig::getCaptionProperties, List.of(supplier -> new a<String>(((Supplier)supplier)::get, x::new))));
        list.add(e.a(this.fieldName("title.descriptionProperties"), this.presentationConfig.getDescriptionProperties(), this.presentationConfig::getDescriptionProperties, List.of(supplier -> new a<String>(((Supplier)supplier)::get, x::new))));
        this.verify(list);
    }

    private void verifyGenerate() {
        List<de.derivo.semspect.server.core.d.i.j<?>> list = this.createGeneralVerifiers();
        list.addAll(List.of(e.a(this.fieldName("indexing.rdfDataSources"), this.generationConfig.getRdfDataSources(), this.generationConfig::getRdfDataSourceObjects, List.of(RDFDataSourceVerifier::create)), e.a(this.fieldName("indicesDirectory"), this.config.getIndicesDirectory(), List.of(p::new, f::new))));
        this.verify(list);
    }

    private void verifyLoad() {
        List<de.derivo.semspect.server.core.d.i.j<?>> list = this.createGeneralVerifiers();
        list.addAll(List.of(e.a(this.fieldName("mode"), this.startupModeInConfiguration, List.of(startupMode -> SemStoreStartupModeVerifier.create(startupMode, this.validatePart))), e.a(this.fieldName("indicesDirectory"), this.config.getIndicesDirectory(), List.of(p::new, j::new, l::new, q::new, v::new, SemStoreIndicesDirVerifier::new))));
        this.verify(list);
    }

    private void verifySmart() {
        List<de.derivo.semspect.server.core.d.i.j<?>> list = this.createGeneralVerifiers();
        list.add(e.a(this.fieldName("smart.indexedDatasetsDirectory"), this.smartModeConfig.getIndexedDatasetsDirectoryAsPath(), List.of(p::new, f::new)));
        this.verify(list);
        list = List.of(e.a(this.fieldName("indexing.rdfDataSources"), this.generationConfig.getRdfDataSources(), this.generationConfig::getRdfDataSourceObjects, List.of(RDFDataSourceVerifier::create)));
        this.verify(list);
    }

    private void verify(List<de.derivo.semspect.server.core.d.i.j<?>> list) {
        new de.derivo.semspect.server.core.d.i.a(list, b.WO).verify();
    }

    private List<de.derivo.semspect.server.core.d.i.j<?>> createGeneralVerifiers() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(e.a(this.fieldName("database"), this.config.getDatabase(), List.of(DatabaseNameWhitelistVerifier::new)));
        return arrayList;
    }

    private String fieldName(String string) {
        return SemStoreConfigurationVerifier.fieldName(string, this.configurationIndex);
    }

    public static String fieldName(String string, int n2) {
        return "semspect.rdf.databases[" + n2 + "]." + string;
    }
}

