/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.server.core.model;

import de.derivo.semspect.server.core.model.datatransferobject.DataTransferObject;
import java.util.Comparator;

public enum Direction implements DataTransferObject
{
    INCOMING,
    OUTGOING,
    BIDIRECTIONAL;

    public static final Comparator<Direction> DIRECTION_SERIALIZATION_COMPARATOR;

    public Direction getInverseDirection() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> OUTGOING;
            case 1 -> INCOMING;
            case 2 -> BIDIRECTIONAL;
        };
    }

    static {
        DIRECTION_SERIALIZATION_COMPARATOR = (direction, direction2) -> {
            if (direction == direction2) {
                return 0;
            }
            if (direction == BIDIRECTIONAL) {
                return -1;
            }
            if (direction == OUTGOING && direction2 == INCOMING) {
                return -1;
            }
            return 1;
        };
    }
}

