/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.server.core.model.datatransferobject;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import de.derivo.semspect.server.core.model.datatransferobject.DataTransferObject;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;

public class NodeTreeDescriptionDTO
implements DataTransferObject {
    private String text;
    private int level;
    private ArrayList<NodeTreeDescriptionDTO> children = new ArrayList();
    private static final String INDENTATION = "    ";

    NodeTreeDescriptionDTO() {
    }

    private NodeTreeDescriptionDTO(@Nonnull String string, int n2) {
        this.text = string;
        this.level = n2;
    }

    @CanIgnoreReturnValue
    public NodeTreeDescriptionDTO addChild(String string) {
        NodeTreeDescriptionDTO nodeTreeDescriptionDTO = new NodeTreeDescriptionDTO(string, this.level + 1);
        this.children.add(nodeTreeDescriptionDTO);
        return nodeTreeDescriptionDTO;
    }

    public static NodeTreeDescriptionDTO newRoot(String string) {
        return new NodeTreeDescriptionDTO(string, 0);
    }

    public void setText(String string) {
        this.text = string;
    }

    public NodeTreeDescriptionDTO setLevel(int n2) {
        this.level = n2;
        return this;
    }

    public NodeTreeDescriptionDTO setChildren(ArrayList<NodeTreeDescriptionDTO> arrayList) {
        this.children = arrayList;
        return this;
    }

    public String toString() {
        return NodeTreeDescriptionDTO.render(this);
    }

    @Nonnull
    public String getText() {
        return this.text;
    }

    public int getLevel() {
        return this.level;
    }

    public ArrayList<NodeTreeDescriptionDTO> getChildren() {
        return this.children;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        NodeTreeDescriptionDTO nodeTreeDescriptionDTO = (NodeTreeDescriptionDTO)object;
        return this.level == nodeTreeDescriptionDTO.level && Objects.equals(this.text, nodeTreeDescriptionDTO.text) && Objects.equals(this.children, nodeTreeDescriptionDTO.children);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.level, this.children);
    }

    private static String render(NodeTreeDescriptionDTO nodeTreeDescriptionDTO) {
        StringBuilder stringBuilder = new StringBuilder();
        NodeTreeDescriptionDTO.render(stringBuilder, nodeTreeDescriptionDTO);
        return stringBuilder.toString();
    }

    private static void render(StringBuilder stringBuilder, NodeTreeDescriptionDTO nodeTreeDescriptionDTO) {
        NodeTreeDescriptionDTO.addIndentation(stringBuilder, nodeTreeDescriptionDTO.getLevel());
        stringBuilder.append(nodeTreeDescriptionDTO.getText());
        stringBuilder.append("\n");
        for (NodeTreeDescriptionDTO nodeTreeDescriptionDTO2 : nodeTreeDescriptionDTO.getChildren()) {
            NodeTreeDescriptionDTO.render(stringBuilder, nodeTreeDescriptionDTO2);
        }
    }

    private static void addIndentation(StringBuilder stringBuilder, int n2) {
        while (--n2 > 0) {
            stringBuilder.append(INDENTATION);
        }
    }
}

