/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.server.core.model.datatransferobject;

import de.derivo.semspect.server.core.model.Direction;
import de.derivo.semspect.server.core.model.datatransferobject.CategoryIdsDTO;
import de.derivo.semspect.server.core.model.datatransferobject.CategoryIdsExclusionDTO;
import de.derivo.semspect.server.core.model.datatransferobject.DataTransferObject;
import de.derivo.semspect.server.core.model.datatransferobject.TreeStateExpansionDTO;
import de.derivo.semspect.server.core.model.datatransferobject.TreeStateExpansionDTO$RelationDTO;
import de.derivo.semspect.server.core.model.datatransferobject.TreeStateNodeDTO$Type;
import de.derivo.semspect.server.core.model.datatransferobject.filter.AbstractFilterDTO;
import de.derivo.utils.a.i.a;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class TreeStateNodeDTO
implements DataTransferObject {
    private String id;
    private TreeStateNodeDTO$Type type = TreeStateNodeDTO$Type.NODE;
    @a
    private CategoryIdsDTO categoryIds = new CategoryIdsDTO();
    @a
    private CategoryIdsExclusionDTO excludeCategoryIds = new CategoryIdsExclusionDTO();
    @a
    private List<String> objectIds = new ArrayList<String>();
    private Set<AbstractFilterDTO> filter = new HashSet<AbstractFilterDTO>();
    private Collection<TreeStateExpansionDTO> expansions = new HashSet<TreeStateExpansionDTO>();
    private String predecessorObject;
    private String note;

    public TreeStateNodeDTO setId(String string) {
        this.id = string;
        return this;
    }

    public TreeStateNodeDTO setType(TreeStateNodeDTO$Type treeStateNodeDTO$Type) {
        this.type = treeStateNodeDTO$Type;
        return this;
    }

    public TreeStateNodeDTO setCategoryIds(CategoryIdsDTO categoryIdsDTO) {
        this.categoryIds = categoryIdsDTO;
        return this;
    }

    public TreeStateNodeDTO setExcludeCategoryIds(CategoryIdsExclusionDTO categoryIdsExclusionDTO) {
        this.excludeCategoryIds = categoryIdsExclusionDTO;
        return this;
    }

    public TreeStateNodeDTO setObjectIds(List<String> list) {
        this.objectIds = list;
        return this;
    }

    public TreeStateNodeDTO setFilter(Set<AbstractFilterDTO> set) {
        this.filter = set;
        return this;
    }

    public TreeStateNodeDTO setExpansions(Collection<TreeStateExpansionDTO> collection) {
        this.expansions = collection;
        return this;
    }

    public TreeStateNodeDTO setPredecessorObject(String string) {
        this.predecessorObject = string;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public TreeStateNodeDTO$Type getType() {
        return this.type;
    }

    public CategoryIdsDTO getCategoryIds() {
        return this.categoryIds;
    }

    public CategoryIdsExclusionDTO getExcludeCategoryIds() {
        return this.excludeCategoryIds;
    }

    public List<String> getObjectIds() {
        return this.objectIds;
    }

    public Set<AbstractFilterDTO> getFilter() {
        return this.filter;
    }

    public Collection<TreeStateExpansionDTO> getExpansions() {
        return this.expansions;
    }

    public String getPredecessorObject() {
        return this.predecessorObject;
    }

    public String getNote() {
        return this.note;
    }

    public TreeStateNodeDTO setNote(String string) {
        this.note = string;
        return this;
    }

    public static Optional<TreeStateNodeDTO> getNodeWithId(TreeStateNodeDTO treeStateNodeDTO, String string) {
        if (treeStateNodeDTO.getId().equals(string)) {
            return Optional.of(treeStateNodeDTO);
        }
        for (TreeStateExpansionDTO treeStateExpansionDTO : treeStateNodeDTO.expansions) {
            Optional<TreeStateNodeDTO> optional = TreeStateNodeDTO.getNodeWithId(treeStateExpansionDTO.getTarget(), string);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    public void addExpansion(String string, String string2, String string3, Direction direction) {
        TreeStateNodeDTO treeStateNodeDTO = new TreeStateNodeDTO().setCategoryIds(CategoryIdsDTO.createSingleton(string3)).setId(string).setType(TreeStateNodeDTO$Type.NODE);
        TreeStateExpansionDTO treeStateExpansionDTO = new TreeStateExpansionDTO().setTarget(treeStateNodeDTO).setRelation(new TreeStateExpansionDTO$RelationDTO().setId(string2).setDirection(direction)).setBackpropagation(false);
        this.expansions.add(treeStateExpansionDTO);
    }

    public Stream<TreeStateNodeDTO> streamDepthFirst() {
        return Stream.concat(Stream.of(this), this.expansions.stream().map(TreeStateExpansionDTO::getTarget).flatMap(TreeStateNodeDTO::streamDepthFirst));
    }

    public Stream<TreeStateExpansionDTO> streamExpansionsDepthFirst() {
        return this.expansions.stream().flatMap(treeStateExpansionDTO -> Stream.concat(Stream.of(treeStateExpansionDTO), treeStateExpansionDTO.getTarget().streamExpansionsDepthFirst()));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TreeStateNodeDTO treeStateNodeDTO = (TreeStateNodeDTO)object;
        return Objects.equals(this.id, treeStateNodeDTO.id) && this.type == treeStateNodeDTO.type && Objects.equals(this.categoryIds, treeStateNodeDTO.categoryIds) && Objects.equals(this.excludeCategoryIds, treeStateNodeDTO.excludeCategoryIds) && Objects.equals(this.objectIds, treeStateNodeDTO.objectIds) && Objects.equals(this.filter, treeStateNodeDTO.filter) && Objects.equals(this.expansions, treeStateNodeDTO.expansions) && Objects.equals(this.predecessorObject, treeStateNodeDTO.predecessorObject);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.categoryIds, this.excludeCategoryIds, this.objectIds, this.filter, this.expansions, this.predecessorObject);
    }

    public String toString() {
        return "TreeStateNodeDTO{id='" + this.id + "', type=" + String.valueOf(this.type) + ", categoryIds=" + String.valueOf(this.categoryIds) + ", excludeCategoryIds=" + String.valueOf(this.excludeCategoryIds) + ", objectIds=" + String.valueOf(this.objectIds) + ", filter=" + String.valueOf(this.filter) + ", expansions=" + String.valueOf(this.expansions) + ", predecessorObject='" + this.predecessorObject + "'}";
    }
}

