/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.server.view.rest.a;

import de.derivo.semspect.server.view.rest.a.h;
import de.derivo.semspect.server.view.rest.a.k;
import de.derivo.semspect.server.view.rest.model.DatabaseAlreadyExists409Response;
import de.derivo.semspect.server.view.rest.model.DatabaseCreateDTO;
import de.derivo.semspect.server.view.rest.model.DatabaseMetaInfoDTO;
import de.derivo.semspect.server.view.rest.model.DatabasePutDTO;
import de.derivo.semspect.server.view.rest.model.DatabasesAnswerDTO;
import de.derivo.semspect.server.view.rest.model.DeleteDatabase423Response;
import de.derivo.semspect.server.view.rest.model.GetDatabase404Response;
import de.derivo.semspect.server.view.rest.model.OperationDTO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Validated
@Tag(name="ManageDatabases", description="the ManageDatabases API")
public interface g {
    default public k wB() {
        return new h(this);
    }

    @Operation(operationId="createDatabase", summary="create a new empty database", tags={"ManageDatabases"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatabaseMetaInfoDTO.class))}), @ApiResponse(responseCode="404", description="Database not found", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetDatabase404Response.class))}), @ApiResponse(responseCode="409", description="Database already exists", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatabaseAlreadyExists409Response.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/database/{databaseID}"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<DatabaseMetaInfoDTO> a(@Parameter(name="databaseID", description="", required=true, in=ParameterIn.PATH) @PathVariable(value="databaseID") String string, @Parameter(name="DatabaseCreateDTO", description="") @Valid @RequestBody(required=false) @Nullable DatabaseCreateDTO databaseCreateDTO) {
        return this.wB().a(string, databaseCreateDTO);
    }

    @Operation(operationId="deleteDatabase", summary="delete the database and all contents on disk", tags={"ManageDatabases"}, responses={@ApiResponse(responseCode="204", description="Deleted"), @ApiResponse(responseCode="404", description="Database not found", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetDatabase404Response.class))}), @ApiResponse(responseCode="423", description="Database Operation in progress", content={@Content(mediaType="application/json", schema=@Schema(implementation=DeleteDatabase423Response.class))})})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/database/{databaseID}"}, produces={"application/json"})
    default public ResponseEntity<Void> ct(@Parameter(name="databaseID", description="", required=true, in=ParameterIn.PATH) @PathVariable(value="databaseID") String string) {
        return this.wB().ct(string);
    }

    @Operation(operationId="getDatabase", summary="get metadata of one database", tags={"MetaInformation"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatabaseMetaInfoDTO.class))}), @ApiResponse(responseCode="404", description="Database not found", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetDatabase404Response.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/database/{databaseID}"}, produces={"application/json"})
    default public ResponseEntity<DatabaseMetaInfoDTO> cu(@Parameter(name="databaseID", description="", required=true, in=ParameterIn.PATH) @PathVariable(value="databaseID") String string) {
        return this.wB().cu(string);
    }

    @Operation(operationId="getDatabases", summary="get metadata of all databases", tags={"MetaInformation"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatabasesAnswerDTO.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/database"}, produces={"application/json"})
    default public ResponseEntity<DatabasesAnswerDTO> wC() {
        return this.wB().wC();
    }

    @Operation(operationId="putContent", summary="overwrite content in database", tags={"Initialization", "ManageDatabasesContent"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationDTO.class))}), @ApiResponse(responseCode="404", description="Database not found", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetDatabase404Response.class))}), @ApiResponse(responseCode="423", description="Database Operation in progress", content={@Content(mediaType="application/json", schema=@Schema(implementation=DeleteDatabase423Response.class))})})
    @RequestMapping(method={RequestMethod.PUT}, value={"/database/{databaseID}/content"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<OperationDTO> a(@Parameter(name="databaseID", description="", required=true, in=ParameterIn.PATH) @PathVariable(value="databaseID") String string, @Parameter(name="DatabasePutDTO", description="") @Valid @RequestBody(required=false) @Nullable DatabasePutDTO databasePutDTO) {
        return this.wB().a(string, databasePutDTO);
    }
}

