/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.server.view.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.derivo.semspect.server.view.rest.model.HistogramDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.lang.Nullable;

public class DataSummary {
    @Nullable
    private Integer numberOfObjects;
    @Nullable
    private Integer numberOfRelations;
    @Nullable
    private Integer numberOfCategories;
    @Nullable
    private String version;
    @Nullable
    private String label;
    @Nullable
    private String description;
    @Valid
    @Nullable
    private @Valid List<@Valid HistogramDTO> histograms;

    public DataSummary numberOfObjects(@Nullable Integer n2) {
        this.numberOfObjects = n2;
        return this;
    }

    @Schema(name="numberOfObjects", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="numberOfObjects")
    @Nullable
    public Integer getNumberOfObjects() {
        return this.numberOfObjects;
    }

    public void setNumberOfObjects(@Nullable Integer n2) {
        this.numberOfObjects = n2;
    }

    public DataSummary numberOfRelations(@Nullable Integer n2) {
        this.numberOfRelations = n2;
        return this;
    }

    @Schema(name="numberOfRelations", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="numberOfRelations")
    @Nullable
    public Integer getNumberOfRelations() {
        return this.numberOfRelations;
    }

    public void setNumberOfRelations(@Nullable Integer n2) {
        this.numberOfRelations = n2;
    }

    public DataSummary numberOfCategories(@Nullable Integer n2) {
        this.numberOfCategories = n2;
        return this;
    }

    @Schema(name="numberOfCategories", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="numberOfCategories")
    @Nullable
    public Integer getNumberOfCategories() {
        return this.numberOfCategories;
    }

    public void setNumberOfCategories(@Nullable Integer n2) {
        this.numberOfCategories = n2;
    }

    public DataSummary version(@Nullable String string) {
        this.version = string;
        return this;
    }

    @Schema(name="version", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="version")
    @Nullable
    public String getVersion() {
        return this.version;
    }

    public void setVersion(@Nullable String string) {
        this.version = string;
    }

    public DataSummary label(@Nullable String string) {
        this.label = string;
        return this;
    }

    @Schema(name="label", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="label")
    @Nullable
    public String getLabel() {
        return this.label;
    }

    public void setLabel(@Nullable String string) {
        this.label = string;
    }

    public DataSummary description(@Nullable String string) {
        this.description = string;
        return this;
    }

    @Schema(name="description", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String string) {
        this.description = string;
    }

    public DataSummary histograms(@Nullable List<@Valid HistogramDTO> list) {
        this.histograms = list;
        return this;
    }

    public DataSummary addHistogramsItem(HistogramDTO histogramDTO) {
        if (this.histograms == null) {
            this.histograms = new ArrayList<HistogramDTO>();
        }
        this.histograms.add(histogramDTO);
        return this;
    }

    @Valid
    @Schema(name="histograms", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="histograms")
    @Nullable
    public @Valid List<@Valid HistogramDTO> getHistograms() {
        return this.histograms;
    }

    public void setHistograms(@Nullable List<@Valid HistogramDTO> list) {
        this.histograms = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DataSummary dataSummary = (DataSummary)object;
        return Objects.equals(this.numberOfObjects, dataSummary.numberOfObjects) && Objects.equals(this.numberOfRelations, dataSummary.numberOfRelations) && Objects.equals(this.numberOfCategories, dataSummary.numberOfCategories) && Objects.equals(this.version, dataSummary.version) && Objects.equals(this.label, dataSummary.label) && Objects.equals(this.description, dataSummary.description) && Objects.equals(this.histograms, dataSummary.histograms);
    }

    public int hashCode() {
        return Objects.hash(this.numberOfObjects, this.numberOfRelations, this.numberOfCategories, this.version, this.label, this.description, this.histograms);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class DataSummary {\n");
        stringBuilder.append("    numberOfObjects: ").append(this.toIndentedString(this.numberOfObjects)).append("\n");
        stringBuilder.append("    numberOfRelations: ").append(this.toIndentedString(this.numberOfRelations)).append("\n");
        stringBuilder.append("    numberOfCategories: ").append(this.toIndentedString(this.numberOfCategories)).append("\n");
        stringBuilder.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        stringBuilder.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        stringBuilder.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        stringBuilder.append("    histograms: ").append(this.toIndentedString(this.histograms)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

