/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.server.view.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.lang.Nullable;

public class NodeTreeDescription {
    @Nullable
    private String text;
    @Nullable
    private Long level;
    @Valid
    @Nullable
    private @Valid List<@Valid NodeTreeDescription> children;

    public NodeTreeDescription text(@Nullable String string) {
        this.text = string;
        return this;
    }

    @Schema(name="text", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="text")
    @Nullable
    public String getText() {
        return this.text;
    }

    public void setText(@Nullable String string) {
        this.text = string;
    }

    public NodeTreeDescription level(@Nullable Long l2) {
        this.level = l2;
        return this;
    }

    @Schema(name="level", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="level")
    @Nullable
    public Long getLevel() {
        return this.level;
    }

    public void setLevel(@Nullable Long l2) {
        this.level = l2;
    }

    public NodeTreeDescription children(@Nullable List<@Valid NodeTreeDescription> list) {
        this.children = list;
        return this;
    }

    public NodeTreeDescription addChildrenItem(NodeTreeDescription nodeTreeDescription) {
        if (this.children == null) {
            this.children = new ArrayList<NodeTreeDescription>();
        }
        this.children.add(nodeTreeDescription);
        return this;
    }

    @Valid
    @Schema(name="children", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="children")
    @Nullable
    public @Valid List<@Valid NodeTreeDescription> getChildren() {
        return this.children;
    }

    public void setChildren(@Nullable List<@Valid NodeTreeDescription> list) {
        this.children = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        NodeTreeDescription nodeTreeDescription = (NodeTreeDescription)object;
        return Objects.equals(this.text, nodeTreeDescription.text) && Objects.equals(this.level, nodeTreeDescription.level) && Objects.equals(this.children, nodeTreeDescription.children);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.level, this.children);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class NodeTreeDescription {\n");
        stringBuilder.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        stringBuilder.append("    level: ").append(this.toIndentedString(this.level)).append("\n");
        stringBuilder.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

