/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.store.exploration.statistics;

import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class AssertionCountFactory {
    private final Function<Long, Long> getAssertionCountForPNodeID;
    private final Set<Long> includedPropertyNodes;
    private final int numberOfThreads;
    private ExecutorService threadPool;

    public AssertionCountFactory(Set<Long> set, Function<Long, Long> function, int n2) {
        this.getAssertionCountForPNodeID = function;
        this.includedPropertyNodes = set;
        this.numberOfThreads = n2;
    }

    private void init() {
        this.initThreadPool();
    }

    private void initThreadPool() {
        this.threadPool = Executors.newFixedThreadPool(this.numberOfThreads);
    }

    private void terminate() {
        if (this.threadPool != null) {
            this.threadPool.shutdownNow();
            try {
                this.threadPool.awaitTermination(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                throw new IllegalStateException();
            }
        }
        this.threadPool = null;
    }

    public Map<Long, Long> generateAssertionCountMap() {
        this.init();
        ArrayList<Callable<Pair>> arrayList = new ArrayList<Callable<Pair>>(this.includedPropertyNodes.size());
        for (Long object2 : this.includedPropertyNodes) {
            Callable<Pair> callable = () -> {
                long l3 = this.getAssertionCountForPNodeID.apply(object2);
                return Pair.of((Object)object2, (Object)l3);
            };
            arrayList.add(callable);
        }
        HashMap hashMap = new HashMap(this.includedPropertyNodes.size());
        try {
            List interruptedException = this.threadPool.invokeAll(arrayList);
            for (Future future : interruptedException) {
                Pair pair = (Pair)future.get();
                hashMap.put((Long)pair.key(), (Long)pair.value());
            }
        }
        catch (InterruptedException executionException) {
            throw new IllegalStateException(executionException);
        }
        catch (ExecutionException executionException) {
            throw new RuntimeException(executionException);
        }
        this.terminate();
        return hashMap;
    }
}

