/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.store.exploration.statistics;

import de.derivo.a.i.a.f;
import de.derivo.a.i.a.n;
import de.derivo.a.i.a.t;
import de.derivo.semspect.store.exploration.statistics.DescriptiveStats;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class PropertyHierarchyStats {
    private transient n propertyHierarchy;
    private long numberOfProperties = 0L;
    private long numberOfPropertyNodes = 0L;
    private long numberOfSymmetricPropertyNodes = 0L;
    private long numberOfAsymmetricPropertyNodes = 0L;
    private long numberOfFunctionalPropertyNodes = 0L;
    private long numberOfInverseFunctionalPropertyNodes = 0L;
    private long numberOfTransitivePropertyNodes = 0L;
    private long numberOfReflexivePropertyNodes = 0L;
    private long numberOfIrreflexivePropertyNodes = 0L;
    private int hierarchyDepth;
    private DescriptiveStats propertiesPerNode;
    private DescriptiveStats childrenPerPropertyNode;

    private PropertyHierarchyStats() {
    }

    public PropertyHierarchyStats(n n2) {
        this.propertyHierarchy = n2;
        this.init();
    }

    private void init() {
        this.numberOfProperties = this.propertyHierarchy.gD().stream().flatMap(f::go).map(t::ha).collect(Collectors.toSet()).size();
        this.numberOfPropertyNodes = this.propertyHierarchy.gD().stream().flatMap(f::go).filter(t2 -> !t2.ha().isEmpty()).collect(Collectors.toSet()).size();
        this.propertyHierarchy.gD().forEach(t2 -> {
            if (t2.ha().isEmpty()) {
                return;
            }
            if (t2.hh()) {
                ++this.numberOfSymmetricPropertyNodes;
            }
            if (t2.hn()) {
                ++this.numberOfAsymmetricPropertyNodes;
            }
            if (t2.hi()) {
                ++this.numberOfFunctionalPropertyNodes;
            }
            if (t2.hk()) {
                ++this.numberOfInverseFunctionalPropertyNodes;
            }
            if (t2.ht()) {
                ++this.numberOfTransitivePropertyNodes;
            }
            if (t2.hp()) {
                ++this.numberOfReflexivePropertyNodes;
            }
            if (t2.hr()) {
                ++this.numberOfIrreflexivePropertyNodes;
            }
        });
        this.hierarchyDepth = this.propertyHierarchy.getHierarchyDepth();
        double[] dArray = this.propertyHierarchy.gC().values().stream().map(t::ha).mapToDouble(Set::size).toArray();
        this.propertiesPerNode = new DescriptiveStats(new DescriptiveStatistics(dArray));
        double[] dArray2 = this.propertyHierarchy.gC().values().stream().map(t::ge).mapToDouble(Set::size).toArray();
        this.childrenPerPropertyNode = new DescriptiveStats(new DescriptiveStatistics(dArray2));
    }

    public long getNumberOfProperties() {
        return this.numberOfProperties;
    }

    public long getNumberOfPropertyNodes() {
        return this.numberOfPropertyNodes;
    }

    public long getNumberOfSymmetricPropertyNodes() {
        return this.numberOfSymmetricPropertyNodes;
    }

    public long getNumberOfAsymmetricPropertyNodes() {
        return this.numberOfAsymmetricPropertyNodes;
    }

    public long getNumberOfFunctionalPropertyNodes() {
        return this.numberOfFunctionalPropertyNodes;
    }

    public long getNumberOfInverseFunctionalPropertyNodes() {
        return this.numberOfInverseFunctionalPropertyNodes;
    }

    public long getNumberOfTransitivePropertyNodes() {
        return this.numberOfTransitivePropertyNodes;
    }

    public long getNumberOfReflexivePropertyNodes() {
        return this.numberOfReflexivePropertyNodes;
    }

    public long getNumberOfIrreflexivePropertyNodes() {
        return this.numberOfIrreflexivePropertyNodes;
    }

    public int getHierarchyDepth() {
        return this.hierarchyDepth;
    }

    public DescriptiveStats getPropertiesPerNode() {
        return this.propertiesPerNode;
    }

    public DescriptiveStats getChildrenPerPropertyNode() {
        return this.childrenPerPropertyNode;
    }
}

