/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.endpoint;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.util.StringUtils;

public final class DefaultMapOAuth2AccessTokenResponseConverter
implements Converter<Map<String, Object>, OAuth2AccessTokenResponse> {
    private static final Set<String> TOKEN_RESPONSE_PARAMETER_NAMES = new HashSet<String>(Arrays.asList("access_token", "expires_in", "refresh_token", "scope", "token_type"));

    public OAuth2AccessTokenResponse convert(Map<String, Object> source) {
        String accessToken = DefaultMapOAuth2AccessTokenResponseConverter.getParameterValue(source, "access_token");
        OAuth2AccessToken.TokenType accessTokenType = DefaultMapOAuth2AccessTokenResponseConverter.getAccessTokenType(source);
        long expiresIn = DefaultMapOAuth2AccessTokenResponseConverter.getExpiresIn(source);
        Set<String> scopes = DefaultMapOAuth2AccessTokenResponseConverter.getScopes(source);
        String refreshToken = DefaultMapOAuth2AccessTokenResponseConverter.getParameterValue(source, "refresh_token");
        LinkedHashMap<String, Object> additionalParameters = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            if (TOKEN_RESPONSE_PARAMETER_NAMES.contains(entry.getKey())) continue;
            additionalParameters.put(entry.getKey(), entry.getValue());
        }
        return OAuth2AccessTokenResponse.withToken(accessToken).tokenType(accessTokenType).expiresIn(expiresIn).scopes(scopes).refreshToken(refreshToken).additionalParameters(additionalParameters).build();
    }

    private static OAuth2AccessToken.TokenType getAccessTokenType(Map<String, Object> tokenResponseParameters) {
        if (OAuth2AccessToken.TokenType.BEARER.getValue().equalsIgnoreCase(DefaultMapOAuth2AccessTokenResponseConverter.getParameterValue(tokenResponseParameters, "token_type"))) {
            return OAuth2AccessToken.TokenType.BEARER;
        }
        if (OAuth2AccessToken.TokenType.DPOP.getValue().equalsIgnoreCase(DefaultMapOAuth2AccessTokenResponseConverter.getParameterValue(tokenResponseParameters, "token_type"))) {
            return OAuth2AccessToken.TokenType.DPOP;
        }
        return null;
    }

    private static long getExpiresIn(Map<String, Object> tokenResponseParameters) {
        return DefaultMapOAuth2AccessTokenResponseConverter.getParameterValue(tokenResponseParameters, "expires_in", 0L);
    }

    private static Set<String> getScopes(Map<String, Object> tokenResponseParameters) {
        if (tokenResponseParameters.containsKey("scope")) {
            String scope = DefaultMapOAuth2AccessTokenResponseConverter.getParameterValue(tokenResponseParameters, "scope");
            return new HashSet<String>(Arrays.asList(StringUtils.delimitedListToStringArray((String)scope, (String)" ")));
        }
        return Collections.emptySet();
    }

    private static String getParameterValue(Map<String, Object> tokenResponseParameters, String parameterName) {
        Object obj = tokenResponseParameters.get(parameterName);
        return obj != null ? obj.toString() : null;
    }

    private static long getParameterValue(Map<String, Object> tokenResponseParameters, String parameterName, long defaultValue) {
        long parameterValue = defaultValue;
        Object obj = tokenResponseParameters.get(parameterName);
        if (obj != null) {
            if (obj.getClass() == Long.class) {
                parameterValue = (Long)obj;
            } else if (obj.getClass() == Integer.class) {
                parameterValue = ((Integer)obj).intValue();
            } else {
                try {
                    parameterValue = Long.parseLong(obj.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return parameterValue;
    }
}

