## Version 19.1.1 (2025-12-09)

- Security: dependencies update

## Version 19.1.0 (2025-11-17)

- New feature: option to enable subclass SPARQL rewriting
- Fixed: ensured concurrency-safety of logging during indexing
- Improved: temporary files cleanup after indexing
- Improved: keyboard interaction (eg: better handling of 'ESC')
- Various small fixes and performance enhancements
- Dependencies update

## Version 19.0.0 (2025-11-01)

- BREAKING: new indices serialization
- New feature: option to disable all inferences
- New feature: option to disable console output during index generation
- New feature: language preference list for captions and descriptions (presentation config)
- New feature: user-defined descriptions for groups in the exploration
- New feature: reset caption and descriptions settings for all categories at once
- Improved: database management API (database configurability, user-defined metadata)
- Improved: handling of xsd:double special values (INF, NaN)
- Improved: keyboard interaction (eg: consistent 'submit' on 'ENTER')
- Improved: caption and description configuration
- Various small fixes and performance enhancements
- Dependencies update
- Renewed free license token

## Version 18.1.0 (2025-06-26)

- New feature: folders to organize saved explorations
- New feature: copy exploration/class links for direct access
- New feature: export/import exploration as json data
- New feature: clickable link icons for URL values
- New feature: exploration pane context menu
- New feature: basic auth authentication scheme
- Improved: indices compatibility between versions
- Improved: OWL 1 compatibility
- Improved: unlimited sessions no longer expire
- Experimental: configure default caption/description for classes
- Various small fixes and performance enhancements
- Dependencies update
- Renewed free license token

## Version 18.0.0 (2025-01-29)

- BREAKING: free version now with restrictions and single sticky session
- BREAKING: renamed start scripts
- BREAKING: new indices serialization
- New feature: setting to show/hide tooltips in exploration menu
- Improved: server starts even if loading indices fails
- Improved: better shortening of long names and IRIs
- Various small fixes and performance enhancements
- Dependencies update

## Version 17.0.3 (2024-10-22)

- Updated: various java and javascript dependencies to address all known vulnerabilities.

## Version 17.0.1 (2024-10-02)

- Updated: `protobuf-java:protobuf-java` to `4.27.5` to address a security
  vulnerability ([CVE-2024-7254](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2024-7254)).

## Version 17.0.0 (2024-09-24)

- New feature: Copy property IRI/label/value in dossier and table view (context menu)
- New feature: Copy IRIs of all resources in a group (context menu)
- New feature: Empty/non-empty filter in table view
- Improved: Ignore OWL 1 vocabulary
- Improved: Fixed TTL parsing issue
- Improved: Fixed errors occurring when displaying collection values
- Improved: Better handling of line breaks by text filter
- Improved: Better handling of special characters and html code in data
- Improved: Added workaround for RDF4J error with SemSpect generated queries
- Various small fixes and performance enhancements
- License valid until the end of 2024 without restrictions

## Version 16.0.1 (2024-06-27)

- New feature: search in exploration and field list menus
- New feature: hide empty fields in object dossier
- New features in table view:
  - extended text search settings (case match, whole word, regular expression)
  - easier (de-)selection of columns (incl. hide empty columns)
  - right click on header for quick menu access
  - empty values are now identifiable
- New feature: load/explore multiple databases (datasets)
- New feature: manage databases via REST
- Improved: group tooltip now contains filter information
- Improved: IRIs of classes and properties are now shown in tooltip
- Improved: extended options for handling of RDF statements
- Improved: sorting and filtering of RDF collections
- License valid until the end of September without restrictions
- Various small fixes and performance enhancements

## Version 15.0.0 (2024-03-28)

- Reworked command line calls
- New feature: dedicated handling for links and image urls (via dossier config file)
- New feature: "repeat expansion" menu entry for faster traversal of uniform data
- New feature: context menu "Start exploration with class" in class tree
- New feature: option to disable domain/range entailment
- New feature: option for exploration menu without resource count (for full performance)
- Improved: input of numerical filters in table views
- Improved: entities with the same rdfs:label now show their IRI for distinction
- Improved: ignore OWL 1 vocabulary
- Experimental: streaming import via SPARQL 1.1 Graph Store HTTP Protocol
- Experimental: SKOS mode for better exploration of SKOS data
- Experimental: facets from classes (via facet config file)
- Various small fixes and performance enhancements
- License valid until the end of June without restrictions

## 14.0.0-beta (2024-01-23)

- Breaking: Renaming of spring server options
- New: SemSpect specific JDK options can be set using the environment variable `SEMSPECT_JDK_OPTIONS`
- New: SemSpect server path be set using the parameter `server.servlet.context-path`
- New: Load rdf dump file from URL
- Experimental: Show top class in class tree
- Experimental: Show classes and properties as resources
- Improved: Better hints on missing or misuse of script arguments
- Fixed: Script fails to start SemSpect with JDK version >= 19
- Fixed: Floats displayed as integers in object dossier

## 13.0.1-beta (2023-12-28)

- First beta release with dedicated in-memory RDF store (SemStore)  