@echo off
setlocal enabledelayedexpansion

rem install directory is directory of given script by default
if not defined SEMSPECT_HOME (
    set SEMSPECT_HOME=%~dp0
)
call "%SEMSPECT_HOME%java-settings.bat"
set MAIN_CLASS="de.derivo.semspect.server.app.rdfrest.SemSpectServerSmartMode"

if not defined SEMSPECT_CONFIG_PATH (
  set SEMSPECT_CONFIG_PATH=!SEMSPECT_HOME!smart-config\semspect_config.yaml
)

if not defined SEMSTORE_CONFIG_PATH (
  set SEMSTORE_CONFIG_PATH=!SEMSPECT_HOME!smart-config\semstore_config.yaml
)

if not defined SEMSTORE_INDICES_DIR (
  set SEMSTORE_INDICES_DIR=!SEMSPECT_HOME!smart-indices
)

if not defined SEMSPECT_CONFIGS_DIR (
  set SEMSPECT_CONFIGS_DIR=!SEMSPECT_HOME!smart-config\datasets
)

echo ===
echo Starting SemSpect in smart mode with configuration:
echo Java command path: %JAVA_PATH%
echo Java class path: %CLASS_PATH%
echo JDK options: %JDK_OPTIONS%
echo Configuration path: %SEMSPECT_CONFIG_PATH%
echo Dataset configurations path: %SEMSPECT_CONFIGS_DIR%
echo Store configuration path: %SEMSTORE_CONFIG_PATH%
echo Store indices path: %SEMSTORE_INDICES_DIR%
echo ===

"%JAVA_PATH%" ^
  -Dde.derivo.semspect.server.configuration.path="%SEMSPECT_CONFIG_PATH%" ^
  %JDK_OPTIONS% ^
  -cp %CLASS_PATH% ^
  !MAIN_CLASS! ^
  --spring.config.additional-location="!SEMSTORE_CONFIG_PATH!" ^
  --indexedDatasetsDirectory="!SEMSTORE_INDICES_DIR!" ^
  --datasetConfigsDirectory="!SEMSPECT_CONFIGS_DIR!" ^
  %*