/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.hdt;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.input.CountingInputStream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.hdt.HDTDictionary;
import org.eclipse.rdf4j.rio.hdt.HDTDictionarySection;
import org.eclipse.rdf4j.rio.hdt.HDTDictionarySectionFactory;
import org.eclipse.rdf4j.rio.hdt.HDTGlobal;
import org.eclipse.rdf4j.rio.hdt.HDTHeader;
import org.eclipse.rdf4j.rio.hdt.HDTTriples;
import org.eclipse.rdf4j.rio.hdt.HDTTriplesSection;
import org.eclipse.rdf4j.rio.hdt.HDTTriplesSectionFactory;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFParser;

public class HDTParser
extends AbstractRDFParser {
    public HDTParser() {
    }

    public HDTParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.HDT;
    }

    public Collection<RioSetting<?>> getSupportedSettings() {
        return Set.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        if (in == null) {
            throw new IllegalArgumentException("Input stream must not be 'null'");
        }
        HDTDictionarySection shared = null;
        HDTDictionarySection subjects = null;
        HDTDictionarySection predicates = null;
        HDTDictionarySection objects = null;
        Iterator section = null;
        try (CountingInputStream bis = new CountingInputStream(in);){
            this.reportLocation(0L, -1L);
            HDTGlobal global = new HDTGlobal();
            global.parse((InputStream)bis);
            Map<String, String> globalProps = global.getProperties();
            String base = globalProps.getOrDefault("BaseUri", "");
            if (!base.isEmpty()) {
                this.setBaseURI(base);
            }
            this.reportLocation(bis.getByteCount(), -1L);
            HDTHeader header = new HDTHeader();
            header.parse((InputStream)bis);
            this.reportLocation(bis.getByteCount(), -1L);
            new HDTDictionary().parse((InputStream)bis);
            long dpos = bis.getByteCount();
            this.reportLocation(dpos, -1L);
            shared = HDTDictionarySectionFactory.parse((InputStream)bis, "S+O", dpos);
            shared.parse((InputStream)bis);
            dpos = bis.getByteCount();
            this.reportLocation(dpos, -1L);
            subjects = HDTDictionarySectionFactory.parse((InputStream)bis, "S", dpos);
            subjects.parse((InputStream)bis);
            dpos = bis.getByteCount();
            this.reportLocation(dpos, -1L);
            predicates = HDTDictionarySectionFactory.parse((InputStream)bis, "P", dpos);
            predicates.parse((InputStream)bis);
            dpos = bis.getByteCount();
            this.reportLocation(dpos, -1L);
            objects = HDTDictionarySectionFactory.parse((InputStream)bis, "O", dpos);
            objects.parse((InputStream)bis);
            this.reportLocation(bis.getByteCount(), -1L);
            HDTTriples triples = new HDTTriples();
            triples.parse((InputStream)bis);
            this.reportLocation(bis.getByteCount(), -1L);
            section = HDTTriplesSectionFactory.parse(new String(HDTTriples.FORMAT_BITMAP));
            ((HDTTriplesSection)section).parse((InputStream)bis, triples.getOrder());
        }
        if (this.rdfHandler != null) {
            this.rdfHandler.startRDF();
        }
        assert (shared != null);
        int size = shared.size();
        assert (section != null);
        while (section.hasNext()) {
            int[] t = (int[])section.next();
            byte[] s = this.getSO(t[0], size, shared, subjects);
            byte[] p = predicates.get(t[1]);
            byte[] o = this.getSO(t[2], size, shared, objects);
            Statement stmt = this.valueFactory.createStatement(this.createSubject(s), this.createPredicate(p), this.createObject(o));
            if (this.rdfHandler == null) continue;
            this.rdfHandler.handleStatement(stmt);
        }
        if (this.rdfHandler != null) {
            this.rdfHandler.endRDF();
        }
    }

    public synchronized void parse(Reader reader, String baseURI) throws RDFParseException, RDFHandlerException {
        throw new UnsupportedOperationException("HDT is binary, text readers not supported.");
    }

    private byte[] getSO(int pos, int size, HDTDictionarySection shared, HDTDictionarySection other) throws IOException {
        return pos <= size ? shared.get(pos) : other.get(pos - size);
    }

    private boolean isBNodeID(byte[] b) {
        return b[0] == 95 || b.length > 5 && b[0] == 103 && b[1] == 101;
    }

    private Resource createSubject(byte[] b) {
        String str = new String(b, StandardCharsets.UTF_8);
        return this.isBNodeID(b) ? this.valueFactory.createBNode(str) : this.valueFactory.createIRI(str);
    }

    private IRI createPredicate(byte[] b) {
        return this.valueFactory.createIRI(new String(b, StandardCharsets.UTF_8));
    }

    private Value createObject(byte[] b) {
        if (b[0] == 34) {
            int i;
            for (i = b.length - 1; i > 1 && b[i] != 34; --i) {
                if (b[i] == 64) {
                    String lang = new String(b, i + 1, b.length - i - 1, StandardCharsets.US_ASCII);
                    return this.valueFactory.createLiteral(new String(b, 1, i - 2, StandardCharsets.UTF_8), lang);
                }
                if (b[i] != 94) continue;
                IRI datatype = this.valueFactory.createIRI(new String(b, i + 2, b.length - i - 3, StandardCharsets.US_ASCII));
                return this.valueFactory.createLiteral(new String(b, 1, i - 3, StandardCharsets.UTF_8), datatype);
            }
            return this.valueFactory.createLiteral(new String(b, 1, i - 1, StandardCharsets.UTF_8));
        }
        String str = new String(b, StandardCharsets.UTF_8);
        return this.isBNodeID(b) ? this.valueFactory.createBNode(str) : this.valueFactory.createIRI(str);
    }
}

