/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.server.app.rdfrest;

import de.derivo.semspect.server.app.rdfrest.Purge;
import de.derivo.semspect.server.app.rdfrest.Run;
import de.derivo.semspect.server.app.rdfrest.SemSpectVersionProvider;
import java.io.File;
import java.util.Optional;
import picocli.CommandLine;

@CommandLine.Command(name="./semspect-smart.sh", subcommands={Run.class, Purge.class, CommandLine.HelpCommand.class}, mixinStandardHelpOptions=true, versionProvider=SemSpectVersionProvider.class, usageHelpWidth=100, description={"Example: ./semspect-smart.sh run turtle-file.ttl ./data/n-triple-files.zip\nDocumentation: https://doc.semspect.de/docs/rdf-server/installation-and-quickstart/"})
public class SemSpectServerSmartMode {
    @CommandLine.Option(names={"-c", "--spring.config.additional-location"}, description={"Path to Spring configuration for SemSpect server"}, hidden=true)
    private File springConfigurationPath;
    @CommandLine.Option(names={"-s", "--indexedDatasetsDirectory"}, description={"Base directory for all SemStore indices"}, required=true, hidden=true)
    private File indexedDatasetsDirectory;
    @CommandLine.Option(names={"-dc", "--datasetConfigsDirectory"}, description={"Base directory for all dataset configurations"}, required=true, hidden=true)
    private File datasetConfigsDirectory;

    public static void main(String[] stringArray) {
        CommandLine commandLine = new CommandLine((Object)new SemSpectServerSmartMode()).setCaseInsensitiveEnumValuesAllowed(true);
        commandLine.execute(stringArray);
    }

    File getIndexedDatasetsDirectory() {
        return this.indexedDatasetsDirectory;
    }

    File getDatasetConfigsDirectory() {
        return this.datasetConfigsDirectory;
    }

    Optional<File> getSpringConfigurationPath() {
        return Optional.ofNullable(this.springConfigurationPath);
    }
}

