/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.server.backend.rdf.configuration;

import de.derivo.semspect.server.backend.rdf.configuration.PresentationConfig;
import de.derivo.semspect.server.backend.rdf.configuration.SemStoreGenerationConfig;
import de.derivo.semspect.server.backend.rdf.configuration.SemStoreInitializationConfig;
import de.derivo.semspect.server.backend.rdf.configuration.SemStoreSmartModeConfig;
import de.derivo.semspect.server.backend.rdf.d.k;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SemStoreConfiguration {
    private String database;
    private String databaseCaption;
    private String indicesDirectory = k.kI().toString();
    private String mode;
    private String contentDescription;
    private ZonedDateTime timestamp = ZonedDateTime.now();
    @NestedConfigurationProperty
    private SemStoreGenerationConfig indexing = new SemStoreGenerationConfig();
    @NestedConfigurationProperty
    private SemStoreInitializationConfig exploration = new SemStoreInitializationConfig();
    @NestedConfigurationProperty
    private SemStoreSmartModeConfig smart = new SemStoreSmartModeConfig();
    @NestedConfigurationProperty
    private PresentationConfig presentation = new PresentationConfig();

    public String getDatabase() {
        return this.database;
    }

    public SemStoreConfiguration setDatabase(String string) {
        this.database = string;
        return this;
    }

    public SemStoreGenerationConfig getIndexing() {
        return this.indexing;
    }

    public void setIndexing(SemStoreGenerationConfig semStoreGenerationConfig) {
        this.indexing = semStoreGenerationConfig;
    }

    public SemStoreInitializationConfig getExploration() {
        return this.exploration;
    }

    public void setExploration(SemStoreInitializationConfig semStoreInitializationConfig) {
        this.exploration = semStoreInitializationConfig;
    }

    public String getIndicesDirectory() {
        return this.indicesDirectory;
    }

    public Path getIndicesDirectoryAsPath() {
        return Path.of(this.indicesDirectory, new String[0]);
    }

    public SemStoreConfiguration setIndicesDirectory(String string) {
        this.indicesDirectory = string;
        return this;
    }

    public SemStoreSmartModeConfig getSmart() {
        return this.smart;
    }

    public void setSmart(SemStoreSmartModeConfig semStoreSmartModeConfig) {
        this.smart = semStoreSmartModeConfig;
    }

    public PresentationConfig getPresentation() {
        return this.presentation;
    }

    public void setPresentation(PresentationConfig presentationConfig) {
        this.presentation = presentationConfig;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String string) {
        this.mode = string;
    }

    @Bean
    public SemStoreGenerationConfig getGenerationConfig() {
        return this.getIndexing();
    }

    @Bean
    public SemStoreInitializationConfig getInitializationConfig() {
        return this.getExploration();
    }

    @Bean
    public SemStoreSmartModeConfig getSmartConfig() {
        return this.getSmart();
    }

    @Bean
    public PresentationConfig getPresentationConfig() {
        return this.presentation;
    }

    public String getContentDescription() {
        return this.contentDescription;
    }

    public SemStoreConfiguration setContentDescription(String string) {
        this.contentDescription = string;
        return this;
    }

    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    public SemStoreConfiguration setTimestamp(ZonedDateTime zonedDateTime) {
        this.timestamp = zonedDateTime;
        return this;
    }

    public String getDatabaseCaption() {
        return this.databaseCaption;
    }

    public void setDatabaseCaption(String string) {
        this.databaseCaption = string;
    }
}

