/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.server.backend.rdf.configuration;

import com.esotericsoftware.kryo.KryoException;
import de.derivo.a.b.l;
import de.derivo.a.k.b.c;
import de.derivo.semspect.server.backend.rdf.a.a;
import de.derivo.semspect.server.backend.rdf.b;
import de.derivo.semspect.server.backend.rdf.configuration.AppConfigContext;
import de.derivo.semspect.server.backend.rdf.configuration.SemSpectErrorCandidatesConfig;
import de.derivo.semspect.server.backend.rdf.configuration.SemStoreConfiguration;
import de.derivo.semspect.server.backend.rdf.configuration.SemStoreGenerationConfig;
import de.derivo.semspect.server.backend.rdf.configuration.SemStoreInitializationConfig;
import de.derivo.semspect.server.backend.rdf.configuration.SemStoreInitializerMode;
import de.derivo.semspect.server.backend.rdf.configuration.SemStoreSmartModeConfig;
import de.derivo.semspect.server.backend.rdf.configuration.SemStoreTestInitializer;
import de.derivo.semspect.server.backend.rdf.configuration.SmartModeCleanOption;
import de.derivo.semspect.server.backend.rdf.configuration.StartupMode;
import de.derivo.semspect.server.backend.rdf.configuration.Util;
import de.derivo.semspect.server.backend.rdf.configuration.verifier.SemStoreConfigurationVerifier;
import de.derivo.semspect.server.core.action.t;
import de.derivo.semspect.server.core.b.F;
import de.derivo.semspect.server.core.b.O;
import de.derivo.semspect.server.core.b.aw;
import de.derivo.semspect.server.core.b.i;
import de.derivo.semspect.server.core.context.s;
import de.derivo.semspect.server.core.d.L;
import de.derivo.semspect.server.core.model.database.Status;
import de.derivo.semspect.store.b.a.f;
import de.derivo.semspect.store.exploration.h;
import de.derivo.semspect.store.exploration.j;
import de.derivo.semspect.store.exploration.k;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ConfigurableApplicationContext;
import org.tinylog.Logger;

public class SemStoreInitializer {
    private StartupMode mode;
    private final int configurationIndex;
    private final SemStoreConfiguration semstoreConfiguration;
    private final AppConfigContext appConfig;
    private final SemStoreGenerationConfig generationConfig;
    private final SemStoreInitializationConfig initializationConfig;
    private final SemStoreSmartModeConfig smartModeConfig;
    private final int dataVersion;
    private final SemStoreInitializerMode initializerMode;
    private final Map<String, Object> metadata;

    private SemStoreInitializer(int n2, AppConfigContext appConfigContext, int n3, SemStoreInitializerMode semStoreInitializerMode, Map<String, Object> map) {
        this.configurationIndex = n2;
        this.semstoreConfiguration = appConfigContext.getSemStoreConfiguration();
        this.appConfig = appConfigContext;
        this.generationConfig = this.semstoreConfiguration.getGenerationConfig();
        this.initializationConfig = this.semstoreConfiguration.getInitializationConfig();
        this.smartModeConfig = this.semstoreConfiguration.getSmartConfig();
        this.dataVersion = n3;
        this.initializerMode = semStoreInitializerMode;
        this.metadata = map;
    }

    public static SemStoreInitializer create(int n2, AppConfigContext appConfigContext, int n3, @Nullable Path path, @Nullable Map<String, Object> map) {
        SemStoreInitializerMode semStoreInitializerMode;
        SemStoreInitializerMode semStoreInitializerMode2 = semStoreInitializerMode = path != null && appConfigContext.getSemStoreConfiguration().getIndicesDirectoryAsPath().startsWith(path) ? SemStoreInitializerMode.MANAGED : SemStoreInitializerMode.USER;
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        return new SemStoreInitializer(n2, appConfigContext, n3, semStoreInitializerMode, map);
    }

    public b getDatabase(ConfigurableApplicationContext configurableApplicationContext) {
        this.initializeStartupType(configurableApplicationContext);
        if (this.semstoreConfiguration.getMode() == null) {
            Logger.info((String)"No semspect.rdf.mode specified. Defaulting to: {}", (Object[])new Object[]{StartupMode.SMART});
            this.mode = StartupMode.SMART;
        }
        return new b(this.getSemspectExploration(configurableApplicationContext), this.configurationIndex, this.appConfig, Status.READY, this.dataVersion, this.metadata);
    }

    private h getSemspectExploration(ConfigurableApplicationContext configurableApplicationContext) {
        if (this.initializerMode == SemStoreInitializerMode.MANAGED) {
            this.setManagedModeIndexDirectory();
        }
        return switch (this.mode) {
            default -> throw new IncompatibleClassChangeError();
            case StartupMode.GENERATE -> this.generateSemStoreIndicesBean(configurableApplicationContext);
            case StartupMode.LOAD -> this.initializeSemStoreFromExistingIndicesBean(configurableApplicationContext);
            case StartupMode.SMART -> this.generateOrInitializeIndices(configurableApplicationContext);
            case StartupMode.CACHED -> SemStoreTestInitializer.rdfExplorationFromInMemory(this.semstoreConfiguration.getIndicesDirectoryAsPath(), this.generationConfig, configurableApplicationContext);
        };
    }

    private void initializeStartupType(ConfigurableApplicationContext configurableApplicationContext) {
        String string = null;
        String string2 = "Available values: " + StartupMode.getModesForEndUser().stream().map(Enum::toString).map(String::toLowerCase).collect(Collectors.joining(", "));
        String string3 = this.semstoreConfiguration.getMode();
        if (string3 == null) {
            string = "Application startup mode cannot be null. " + string2;
        } else if (string3.isEmpty()) {
            string = "Application startup mode cannot be empty. " + string2;
        } else if (!StartupMode.isSupportedStartupMode(string3)) {
            string = "Provided startup mode is not supported. " + string2;
        }
        if (string != null) {
            String string4 = Util.formatException(new F(string, "semspect.rdf.databases[" + this.configurationIndex + "].mode", (Object)string3));
            Logger.error((String)"Errors in specified application startup mode:\n\n{}", (Object[])new Object[]{string4});
            Util.exit(configurableApplicationContext, 1);
        }
        this.mode = StartupMode.valueOf(string3.toUpperCase());
    }

    h generateSemStoreIndicesBean(ConfigurableApplicationContext configurableApplicationContext) {
        this.checkConfiguration(this.configurationIndex, this.mode, this.semstoreConfiguration, configurableApplicationContext);
        return SemStoreInitializer.generateSemStoreIndices(this.semstoreConfiguration.getIndicesDirectoryAsPath(), this.generationConfig, configurableApplicationContext, this.initializerMode);
    }

    public static h generateSemStoreIndices(Path path, SemStoreGenerationConfig semStoreGenerationConfig, ConfigurableApplicationContext configurableApplicationContext, SemStoreInitializerMode semStoreInitializerMode) {
        Logger.info((Object)"Creating rdf connection from rdffile");
        Logger.info((String)"Will try to read specified rdf sources: {}", (Object[])new Object[]{semStoreGenerationConfig.getRdfDataSources()});
        de.derivo.semspect.store.c.a a2 = SemStoreInitializer.getErrorCandidateConfig(semStoreGenerationConfig);
        try {
            SemStoreInitializer.checkLicenses(configurableApplicationContext);
            h h2 = new k(semStoreGenerationConfig.getRdfDataSourceObjects(), path).b(c.rm).v(semStoreGenerationConfig.getNumberOfThreads()).a(semStoreGenerationConfig.getSortingLanguage() == null ? null : new Locale(semStoreGenerationConfig.getSortingLanguage())).a(semStoreGenerationConfig.getParsingStrategy()).o(semStoreGenerationConfig.isValidateParsedResources()).d(semStoreGenerationConfig.getStringLiteralDictionarySectionType()).a(semStoreGenerationConfig.getConsoleLogMode()).K(semStoreGenerationConfig.isDisableDomainRangeEntailment()).M(semStoreGenerationConfig.isDisableSubClassOfEntailment()).N(semStoreGenerationConfig.isDisableSubPropertyOfEntailment()).L(semStoreGenerationConfig.isDisableSymmetricPropertyAndInverseOfEntailment()).e(semStoreGenerationConfig.getIriDictionarySectionType()).r(semStoreGenerationConfig.isIndexReificationTriples()).E(semStoreGenerationConfig.isTranslateSKOSToRDFS() ? List.of(l.hL) : null).a(() -> Runtime.getRuntime().halt(1)).a(a2).cN("SemSpect-" + L.getVersion()).xE().xu();
            if (semStoreGenerationConfig.isTerminateAfterIndexing()) {
                h2.terminate();
                Logger.info((Object)"Terminating RDF SemSpect since 'terminateAfterIndexing' option was set to 'true'.");
                Util.exit(configurableApplicationContext, 0);
            }
            return h2;
        }
        catch (Exception exception) {
            Logger.error((Throwable)exception);
            Logger.error((Object)"Something went wrong while generating all SemStore indices for the provided RDF datasets.");
            throw new O(exception);
        }
    }

    @Nullable
    private static de.derivo.semspect.store.c.a getErrorCandidateConfig(SemStoreGenerationConfig semStoreGenerationConfig) {
        de.derivo.semspect.store.c.a a2 = null;
        if (semStoreGenerationConfig.getErrorCandidateGeneration().isEnabled()) {
            a2 = new de.derivo.semspect.store.c.a();
            SemSpectErrorCandidatesConfig semSpectErrorCandidatesConfig = semStoreGenerationConfig.getErrorCandidateGeneration();
            a2.setThresholdIfUsageHigherThenAssertionRequired(semSpectErrorCandidatesConfig.getThresholdIfUsageHigherThenAssertionRequired());
            a2.setThresholdIfUsageLowerThenAssertionRedundant(semSpectErrorCandidatesConfig.getThresholdIfUsageLowerThenAssertionRedundant());
            a2.setMinimumRequiredSampleSize(semSpectErrorCandidatesConfig.getMinimumRequiredSampleSize());
        }
        return a2;
    }

    public static h initializeSemStoreFromExistingIndices(Path path, SemStoreInitializerMode semStoreInitializerMode, SemStoreInitializationConfig semStoreInitializationConfig, ConfigurableApplicationContext configurableApplicationContext) {
        try {
            SemStoreInitializer.checkLicenses(configurableApplicationContext);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new i("Supplied rdf directory does not exist: " + String.valueOf(path.toAbsolutePath()));
            }
            if (!Files.isDirectory(path, new LinkOption[0])) {
                throw new i("Supplied rdf directory is not a directory: " + String.valueOf(path.toAbsolutePath()));
            }
            return j.a(path, semStoreInitializationConfig.getNumberOfThreads());
        }
        catch (i | f exception) {
            Logger.error((Throwable)exception.getCause());
            if (exception.getCause() instanceof KryoException) {
                Logger.error((Object)"A serialization issue occurred. The version of the provided indices might be incompatible with your installed RDF SemSpect version.");
            } else {
                Logger.error((Object)"Something went wrong while initializing SemSpect. ");
            }
            Logger.error((Object)"Consider generating all SemStore indices anew for the respective RDF datasets ('--clean' flag in terminal application).");
            throw new O(exception);
        }
    }

    h initializeSemStoreFromExistingIndicesBean(ConfigurableApplicationContext configurableApplicationContext) {
        Logger.info((Object)"Creating rdf connection from rdfdump");
        this.checkConfiguration(this.configurationIndex, StartupMode.LOAD, this.semstoreConfiguration, configurableApplicationContext);
        return SemStoreInitializer.initializeSemStoreFromExistingIndices(this.semstoreConfiguration.getIndicesDirectoryAsPath(), this.initializerMode, this.initializationConfig, configurableApplicationContext);
    }

    h generateOrInitializeIndices(ConfigurableApplicationContext configurableApplicationContext) {
        this.checkConfiguration(this.configurationIndex, StartupMode.SMART, this.semstoreConfiguration, configurableApplicationContext);
        Path path = SemStoreInitializer.getSmartModeIndicesDir(this.semstoreConfiguration);
        Path path2 = SemStoreInitializer.getSmartModeConfigDir(this.semstoreConfiguration);
        SmartModeCleanOption smartModeCleanOption = this.smartModeConfig.getCleanOption();
        try {
            if (smartModeCleanOption == SmartModeCleanOption.DATA || smartModeCleanOption == SmartModeCleanOption.ALL) {
                FileUtils.deleteDirectory((File)path.toFile());
            }
            if (smartModeCleanOption == SmartModeCleanOption.CONFIG || smartModeCleanOption == SmartModeCleanOption.ALL) {
                FileUtils.deleteDirectory((File)path2.toFile());
            }
        }
        catch (IOException iOException) {
            Logger.error((Throwable)iOException);
            Util.exit(configurableApplicationContext, 1);
        }
        this.semstoreConfiguration.setIndicesDirectory(path.toString());
        if (Files.exists(path, new LinkOption[0])) {
            this.checkConfiguration(this.configurationIndex, StartupMode.LOAD, this.semstoreConfiguration, configurableApplicationContext);
            return SemStoreInitializer.initializeSemStoreFromExistingIndices(path, this.initializerMode, this.initializationConfig, configurableApplicationContext);
        }
        this.checkConfiguration(this.configurationIndex, StartupMode.GENERATE, this.semstoreConfiguration, configurableApplicationContext);
        return SemStoreInitializer.generateSemStoreIndices(path, this.generationConfig, configurableApplicationContext, this.initializerMode);
    }

    @NotNull
    public static Path getSmartModeConfigDir(SemStoreConfiguration semStoreConfiguration) {
        Path path = semStoreConfiguration.getSmart().getDatasetConfigurationsDirectoryAsPath();
        return de.derivo.semspect.server.backend.rdf.d.k.a(path, semStoreConfiguration.getGenerationConfig().getRdfDataSourceObjects());
    }

    @NotNull
    public static Path getSmartModeIndicesDir(SemStoreConfiguration semStoreConfiguration) {
        Path path = semStoreConfiguration.getSmart().getIndexedDatasetsDirectoryAsPath();
        return de.derivo.semspect.server.backend.rdf.d.k.a(path, semStoreConfiguration.getGenerationConfig().getRdfDataSourceObjects());
    }

    private static void checkLicenses(ConfigurableApplicationContext configurableApplicationContext) {
        try {
            new a(null, null, null, configurableApplicationContext).d(s.ou());
        }
        catch (Exception exception) {
            Optional<aw> optional = t.md().a(exception);
            String string = optional.map(Util::formatException).orElseGet(() -> Util.formatException(exception));
            Logger.error((String)"Errors in semspect license\n\n{}", (Object[])new Object[]{string});
            Util.exit(configurableApplicationContext, 1);
        }
    }

    void checkConfiguration(int n2, StartupMode startupMode, SemStoreConfiguration semStoreConfiguration, ConfigurableApplicationContext configurableApplicationContext) {
        SemStoreConfigurationVerifier semStoreConfigurationVerifier = new SemStoreConfigurationVerifier(n2, this.mode, startupMode, semStoreConfiguration);
        Util.checkConfiguration(configurableApplicationContext, semStoreConfigurationVerifier, this.initializerMode == SemStoreInitializerMode.USER);
    }

    private void setManagedModeIndexDirectory() {
        if (this.mode == StartupMode.LOAD) {
            return;
        }
        Path path = this.dataVersion == 0 ? Paths.get(this.semstoreConfiguration.getIndicesDirectory(), "index-" + this.dataVersion) : Paths.get(this.semstoreConfiguration.getIndicesDirectory(), new String[0]).getParent().resolve("index-" + this.dataVersion % 2);
        Logger.debug((String)"Indices directory for dataVersion {} set to: {}", (Object[])new Object[]{this.dataVersion, path});
        this.semstoreConfiguration.setIndicesDirectory(path.toAbsolutePath().toString());
    }

    public StartupMode getStartupMode() {
        return this.mode;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }
}

