/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.server.backend.rdf.configuration;

import de.derivo.a.d.e;
import de.derivo.a.f.a.d;
import de.derivo.semspect.server.core.b.F;
import de.derivo.semspect.server.core.b.G;
import de.derivo.semspect.server.core.b.h;
import de.derivo.semspect.server.core.b.i;
import de.derivo.semspect.server.core.d.i.a.c;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.tinylog.Logger;

public class Util {
    public static List<d> getRDFDataSources(String string) {
        try {
            URL uRL = new URL(string);
            if (uRL.getProtocol().equals("file")) {
                return d.d(Paths.get(uRL.toURI()));
            }
            return d.a(uRL);
        }
        catch (MalformedURLException | URISyntaxException exception) {
        }
        catch (RuntimeException runtimeException) {
            throw new e("Provided URL cannot be used as data source. Reason: " + runtimeException.getMessage());
        }
        try {
            Path path = Paths.get(string, new String[0]);
            return d.d(path);
        }
        catch (UnsupportedRDFormatException unsupportedRDFormatException) {
            throw new e("Unsupported RDF format: " + string, unsupportedRDFormatException);
        }
        catch (Exception exception) {
            throw new e("Provided data source is neither a path nor a usable URL (URLs must start with protocol): " + string, exception);
        }
    }

    static String formatException(Throwable throwable) {
        i i2;
        StringBuilder stringBuilder = new StringBuilder();
        if (throwable instanceof F) {
            i2 = (F)throwable;
            stringBuilder.append("  Property: ").append(((F)i2).pA()).append("\n");
            stringBuilder.append("  Value: ").append(((F)i2).getValue()).append("\n");
        }
        if (throwable instanceof G) {
            i2 = (G)throwable;
            stringBuilder.append("  Properties: ").append(((G)i2).getFields()).append("\n");
            stringBuilder.append("  Values: ").append(((G)i2).getValues()).append("\n");
        }
        stringBuilder.append("  Reason: ").append(throwable.getMessage());
        return stringBuilder.toString();
    }

    static void exit(ConfigurableApplicationContext configurableApplicationContext, int n2) {
        System.exit(SpringApplication.exit((ApplicationContext)configurableApplicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> n2}));
    }

    static void exitOrThrow(ConfigurableApplicationContext configurableApplicationContext, int n2, boolean bl2, RuntimeException runtimeException) {
        if (bl2) {
            Util.exit(configurableApplicationContext, n2);
        }
        throw runtimeException;
    }

    static void checkConfiguration(ConfigurableApplicationContext configurableApplicationContext, c c2, boolean bl2) {
        try {
            c2.verify();
        }
        catch (h h2) {
            String string = h2.pt().stream().map(Util::formatException).collect(Collectors.joining("\n\n"));
            Logger.error((String)"Errors in configuration\n\n{}", (Object[])new Object[]{string});
            Util.exitOrThrow(configurableApplicationContext, 1, bl2, new i(string));
        }
        catch (RuntimeException runtimeException) {
            Logger.error((String)"Error in configuration\n\n{}", (Object[])new Object[]{Util.formatException(runtimeException)});
            Util.exitOrThrow(configurableApplicationContext, 1, bl2, runtimeException);
        }
        catch (Throwable throwable) {
            Logger.error((String)"Error in configuration\n\n{}", (Object[])new Object[]{Util.formatException(throwable)});
            Util.exitOrThrow(configurableApplicationContext, 1, bl2, new RuntimeException(throwable));
        }
    }
}

