/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.server.backend.rdf.configuration.verifier;

import de.derivo.semspect.server.backend.rdf.configuration.SemStoreConfiguration;
import de.derivo.semspect.server.backend.rdf.configuration.SemStoresConfiguration;
import de.derivo.semspect.server.backend.rdf.configuration.verifier.SemStoreConfigurationVerifier;
import de.derivo.semspect.server.backend.rdf.service.persistence.DatabaseSerialization;
import de.derivo.semspect.server.core.b.i;
import de.derivo.semspect.server.core.d.i.a;
import de.derivo.semspect.server.core.d.i.a.c;
import de.derivo.semspect.server.core.d.i.a.e;
import de.derivo.semspect.server.core.d.i.a.r;
import de.derivo.semspect.server.core.d.i.b;
import de.derivo.semspect.server.core.d.i.j;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SemStoresConfigurationVerifier
implements c {
    private final SemStoresConfiguration config;

    public SemStoresConfigurationVerifier(SemStoresConfiguration semStoresConfiguration) {
        this.config = semStoresConfiguration;
    }

    @Override
    public void verify() {
        List<j<?>> list = this.createManagedDatabaseNamesUniquenessVerifier();
        list.addAll(this.createIndicesMustBeLocatedOutsideManagedDirectory());
        list.addAll(List.of(e.a("database names can't be empty", "semspect.rdf.databases", ".database", this.config.getDatabases(), SemStoreConfiguration::getDatabase, r::new), e.a("indices directories must be unique", "semspect.rdf.databases", ".indicesDirectory", this.config.getDatabases(), SemStoreConfiguration::getIndicesDirectory)));
        new a(list, b.WO).verify();
    }

    private List<j<?>> createManagedDatabaseNamesUniquenessVerifier() {
        de.derivo.semspect.server.backend.rdf.service.persistence.a a2 = new de.derivo.semspect.server.backend.rdf.service.persistence.a(Paths.get(this.config.getManaged().getIndicesDirectory(), new String[0]));
        Set set = a2.kC().stream().map(DatabaseSerialization::getSemStoreConfiguration).map(SemStoreConfiguration::getDatabase).collect(Collectors.toSet());
        List<SemStoreConfiguration> list = this.config.getDatabases();
        return IntStream.range(0, list.size()).mapToObj(n2 -> {
            String string = ((SemStoreConfiguration)list.get(n2)).getDatabase();
            return new de.derivo.semspect.server.core.d.i.a.i(SemStoreConfigurationVerifier.fieldName("database", n2), string, () -> {
                if (set.contains(this.config.getDatabases().get(n2).getDatabase())) {
                    throw new i("Database name " + string + " collides with database name of managed databases defined in " + this.config.getManaged().getIndicesDirectory());
                }
            });
        }).collect(Collectors.toList());
    }

    private List<? extends j<?>> createIndicesMustBeLocatedOutsideManagedDirectory() {
        List<Path> list = this.config.getDatabases().stream().map(SemStoreConfiguration::getIndicesDirectoryAsPath).toList();
        Optional<Path> optional = this.config.getManaged().getIndicesDirectoryAsPath();
        if (optional.isEmpty()) {
            return List.of();
        }
        return IntStream.range(0, list.size()).mapToObj(n2 -> {
            Path path = (Path)list.get(n2);
            Path path2 = (Path)optional.get();
            return new de.derivo.semspect.server.core.d.i.a.i(SemStoreConfigurationVerifier.fieldName("indicesDirectory", n2), path, () -> {
                if (path.startsWith(path2)) {
                    throw new i("IndicesDirectory " + String.valueOf(path) + " can't be located in managedIndicesDirectory " + String.valueOf(path2));
                }
            });
        }).collect(Collectors.toList());
    }
}

