/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.server.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.derivo.semspect.server.core.model.datatransferobject.DataTransferObject;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class AllowanceDTO
implements DataTransferObject {
    private final boolean allowed;
    private final String tag;
    private final Integer limit;

    @JsonCreator
    public AllowanceDTO(@JsonProperty(value="allowed") boolean bl2, @JsonProperty(value="tag") @Nullable String string, @JsonProperty(value="limit") @Nullable Integer n2) {
        this.allowed = bl2;
        this.tag = string;
        this.limit = n2;
    }

    public static AllowanceDTO create(boolean bl2) {
        return new AllowanceDTO(bl2, null, null);
    }

    public static AllowanceDTO createPro(boolean bl2) {
        return new AllowanceDTO(bl2, "pro", null);
    }

    public static AllowanceDTO createPro(int n2) {
        return new AllowanceDTO(true, "pro", n2);
    }

    public static AllowanceDTO createLimited(String string, int n2) {
        return new AllowanceDTO(true, string, n2);
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public Optional<String> getTag() {
        return Optional.ofNullable(this.tag);
    }

    public Optional<Integer> getLimit() {
        return Optional.ofNullable(this.limit);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AllowanceDTO allowanceDTO = (AllowanceDTO)object;
        return this.allowed == allowanceDTO.allowed && Objects.equals(this.tag, allowanceDTO.tag) && Objects.equals(this.limit, allowanceDTO.limit);
    }

    public int hashCode() {
        return Objects.hash(this.allowed, this.tag, this.limit);
    }

    public String toString() {
        return "{\"allowed\": \"" + this.allowed + "\"" + (String)(this.tag != null ? ", \"tag\": \"" + this.tag + "\"" + (String)(this.limit != null ? ", \"limit\": \"" + this.limit + "\"" : "") : "") + "}";
    }
}

