/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.server.core.model.datatransferobject;

import de.derivo.semspect.server.core.model.datatransferobject.DataTransferObject;
import de.derivo.semspect.server.core.model.datatransferobject.Element;
import de.derivo.semspect.server.core.model.datatransferobject.ExpansionOptionsDTO;
import de.derivo.semspect.server.core.model.datatransferobject.HistogramsDTO;
import de.derivo.semspect.server.core.model.datatransferobject.NodeExpansionDTO;
import de.derivo.semspect.server.core.model.datatransferobject.SemspectObjectDTO;
import de.derivo.semspect.server.core.model.datatransferobject.filter.AbstractFilterDTO;
import de.derivo.utils.a.i.a;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public class NodeDTO
extends Element<NodeDTO>
implements DataTransferObject {
    @a
    private List<List<String>> categoryIds;
    @a
    private List<List<List<String>>> excludeCategoryIds;
    private List<AbstractFilterDTO> filter;
    @a
    private List<String> objectIds;
    private HistogramsDTO histograms;
    @a
    private List<String> predecessorIds = new ArrayList<String>();
    private String description;
    private long objectCount;
    private String objectCountAccuracy;
    private List<SemspectObjectDTO> objects = new ArrayList<SemspectObjectDTO>();
    private ExpansionOptionsDTO expansionOptions;
    private List<NodeExpansionDTO> expansions = new ArrayList<NodeExpansionDTO>();

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        NodeDTO nodeDTO = (NodeDTO)object;
        return this.objectCount == nodeDTO.objectCount && Objects.equals(this.categoryIds, nodeDTO.categoryIds) && Objects.equals(this.excludeCategoryIds, nodeDTO.excludeCategoryIds) && Objects.equals(this.filter, nodeDTO.filter) && Objects.equals(this.objectIds, nodeDTO.objectIds) && Objects.equals(this.histograms, nodeDTO.histograms) && Objects.equals(new HashSet<String>(this.predecessorIds), new HashSet<String>(nodeDTO.predecessorIds)) && Objects.equals(this.description, nodeDTO.description) && Objects.equals(this.objectCountAccuracy, nodeDTO.objectCountAccuracy) && Objects.equals(new HashSet<SemspectObjectDTO>(this.objects), new HashSet<SemspectObjectDTO>(nodeDTO.objects)) && Objects.equals(this.expansionOptions, nodeDTO.expansionOptions) && Objects.equals(this.expansions, nodeDTO.expansions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.categoryIds, this.excludeCategoryIds, this.filter, this.objectIds, this.histograms, new HashSet<String>(this.predecessorIds), this.description, this.objectCount, this.objectCountAccuracy, new HashSet<SemspectObjectDTO>(this.objects), this.expansionOptions, this.expansions);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", NodeDTO.class.getSimpleName() + "[", "]").add("id=" + super.getId()).add("categoryIds=" + String.valueOf(this.categoryIds)).add("excludeCategoryIds=" + String.valueOf(this.excludeCategoryIds)).add("filter=" + String.valueOf(this.filter)).add("objectIds=" + String.valueOf(this.objectIds)).add("histograms=" + String.valueOf(this.histograms)).add("predecessorIds=" + String.valueOf(this.predecessorIds)).add("description='" + this.description + "'").add("objectCount=" + this.objectCount).add("objectCountAccuracy='" + this.objectCountAccuracy + "'").add("objects=" + String.valueOf(this.objects)).add("expansionOptions=" + String.valueOf(this.expansionOptions)).add("expansions=" + String.valueOf(this.expansions)).toString();
    }

    public NodeDTO setCategoryIds(List<List<String>> list) {
        this.categoryIds = list;
        return this;
    }

    public NodeDTO setCategoryId(String string) {
        this.categoryIds = new ArrayList<List<String>>();
        this.categoryIds.add(new ArrayList());
        this.categoryIds.get(0).add(string);
        return this;
    }

    public NodeDTO setExcludeCategoryIds(List<List<List<String>>> list) {
        this.excludeCategoryIds = list;
        return this;
    }

    public NodeDTO setFilter(List<AbstractFilterDTO> list) {
        this.filter = list;
        return this;
    }

    public NodeDTO setHistograms(HistogramsDTO histogramsDTO) {
        this.histograms = histogramsDTO;
        return this;
    }

    @Override
    public NodeDTO setDescription(String string) {
        this.description = string;
        return this;
    }

    public NodeDTO setObjectCount(long l2) {
        this.objectCount = l2;
        return this;
    }

    public NodeDTO setObjectCountAccuracy(String string) {
        this.objectCountAccuracy = string;
        return this;
    }

    public NodeDTO setObjects(List<SemspectObjectDTO> list) {
        this.objects = list;
        return this;
    }

    public NodeDTO setObjectIds(List<String> list) {
        this.objectIds = list;
        return this;
    }

    public NodeDTO setExpansionOptions(ExpansionOptionsDTO expansionOptionsDTO) {
        this.expansionOptions = expansionOptionsDTO;
        return this;
    }

    public NodeDTO addExpansion(NodeExpansionDTO nodeExpansionDTO) {
        this.expansions.add(nodeExpansionDTO);
        return this;
    }

    public List<List<String>> getCategoryIds() {
        return this.categoryIds;
    }

    public List<List<List<String>>> getExcludeCategoryIds() {
        return this.excludeCategoryIds;
    }

    public List<AbstractFilterDTO> getFilter() {
        return this.filter;
    }

    public HistogramsDTO getHistograms() {
        return this.histograms;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public long getObjectCount() {
        return this.objectCount;
    }

    public String getObjectCountAccuracy() {
        return this.objectCountAccuracy;
    }

    public List<SemspectObjectDTO> getObjects() {
        return this.objects;
    }

    public ExpansionOptionsDTO getExpansionOptions() {
        return this.expansionOptions;
    }

    public List<String> getPredecessorIds() {
        return this.predecessorIds;
    }

    public List<NodeExpansionDTO> getExpansions() {
        return this.expansions;
    }

    public NodeDTO setExpansions(List<NodeExpansionDTO> list) {
        this.expansions = list;
        return this;
    }

    public NodeDTO setPredecessorIds(List<String> list) {
        this.predecessorIds = list;
        return this;
    }

    public List<String> getObjectIds() {
        return this.objectIds;
    }

    @Override
    protected NodeDTO self() {
        return this;
    }
}

