/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.server.view.rest;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import de.derivo.semspect.server.core.d.k.g;
import de.derivo.semspect.server.core.d.k.k;
import de.derivo.semspect.server.view.rest.ServerConfiguration;
import de.derivo.semspect.server.view.rest.a;
import de.derivo.semspect.server.view.rest.b;
import de.derivo.semspect.server.view.rest.c;
import de.derivo.semspect.server.view.rest.d;
import de.derivo.semspect.server.view.rest.e;
import de.derivo.semspect.server.view.rest.f;
import de.derivo.semspect.server.view.rest.h;
import de.derivo.semspect.server.view.rest.model.ConnectionDetailsDTOHeadersInner;
import de.derivo.semspect.server.view.rest.model.ConnectionDetailsRowInner;
import de.derivo.semspect.server.view.rest.model.DossierSectionFieldsInner;
import de.derivo.semspect.server.view.rest.model.FiltersInner;
import de.derivo.semspect.server.view.rest.model.NodeDetailsRowInner;
import de.derivo.utils.obfuscation.Api;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.FullyQualifiedAnnotationBeanNameGenerator;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.UrlPathHelper;

@SpringBootApplication(scanBasePackages={"de.derivo.semspect.server"}, nameGenerator=FullyQualifiedAnnotationBeanNameGenerator.class)
@EnableWebSecurity
@EnableWebMvc
public class SemSpectServer
implements Api,
ApplicationListener,
WebMvcConfigurer {
    private static final Logger log = c.wv();
    @Autowired
    private ServerConfiguration serverConfiguration;

    public static void main(String ... stringArray) {
        block2: {
            log.info(c.wx());
            try {
                SpringApplication.run(SemSpectServer.class, (String[])stringArray);
            }
            catch (UnsatisfiedDependencyException unsatisfiedDependencyException) {
                if (!de.derivo.semspect.server.core.a.Cl) break block2;
                log.error("Failed to start", (Throwable)unsatisfiedDependencyException);
            }
        }
    }

    public void onApplicationEvent(@Nonnull ApplicationEvent applicationEvent) {
        if (!(applicationEvent instanceof ContextRefreshedEvent)) {
            return;
        }
        ContextRefreshedEvent contextRefreshedEvent = (ContextRefreshedEvent)applicationEvent;
        ApplicationContext applicationContext = contextRefreshedEvent.getApplicationContext();
        RequestMappingHandlerMapping requestMappingHandlerMapping = (RequestMappingHandlerMapping)applicationContext.getBean("requestMappingHandlerMapping", RequestMappingHandlerMapping.class);
        Map map = requestMappingHandlerMapping.getHandlerMethods();
        log.debug("Available routes: ");
        map.forEach((requestMappingInfo, handlerMethod) -> log.debug(String.valueOf(requestMappingInfo) + " " + String.valueOf(handlerMethod)));
    }

    @Bean
    public k objectMapper() {
        return g.c(mapperBuilder -> mapperBuilder.addModule(this.customDeserializationModule()));
    }

    public Module customDeserializationModule() {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(DossierSectionFieldsInner.class, (JsonDeserializer)new d()).addDeserializer(FiltersInner.class, (JsonDeserializer)new e()).addDeserializer(NodeDetailsRowInner.class, (JsonDeserializer)new f()).addDeserializer(ConnectionDetailsDTOHeadersInner.class, (JsonDeserializer)new a()).addDeserializer(ConnectionDetailsRowInner.class, (JsonDeserializer)new b());
        return simpleModule;
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> list) {
        list.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        list.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter(this.objectMapper().GW()));
        list.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        list.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
    }

    public Jackson2ObjectMapperBuilder jackson2ObjectMapperBuilder() {
        Jackson2ObjectMapperBuilder jackson2ObjectMapperBuilder = new Jackson2ObjectMapperBuilder();
        jackson2ObjectMapperBuilder.deserializersByType(Map.of(FiltersInner.class, new e()));
        return jackson2ObjectMapperBuilder;
    }

    public void addResourceHandlers(ResourceHandlerRegistry resourceHandlerRegistry) {
        resourceHandlerRegistry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{this.serverConfiguration.getFrontendLocation()});
    }

    public void addCorsMappings(CorsRegistry corsRegistry) {
        corsRegistry.addMapping("/**").allowedOriginPatterns(new String[]{"*"}).allowedMethods(new String[]{"*"}).allowCredentials(true);
    }

    public void configurePathMatch(PathMatchConfigurer pathMatchConfigurer) {
        UrlPathHelper urlPathHelper = new UrlPathHelper();
        urlPathHelper.setUrlDecode(false);
        pathMatchConfigurer.setUrlPathHelper(urlPathHelper);
    }

    public void addFormatters(FormatterRegistry formatterRegistry) {
        formatterRegistry.addConverter((Converter)new h());
    }

    public void configureAsyncSupport(AsyncSupportConfigurer asyncSupportConfigurer) {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(1);
        threadPoolTaskExecutor.setMaxPoolSize(10);
        threadPoolTaskExecutor.setThreadNamePrefix("mvc-task-executor-");
        threadPoolTaskExecutor.initialize();
        asyncSupportConfigurer.setTaskExecutor((AsyncTaskExecutor)threadPoolTaskExecutor);
    }
}

