/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.server.view.rest.a;

import de.derivo.semspect.server.view.rest.a.B;
import de.derivo.semspect.server.view.rest.a.E;
import de.derivo.semspect.server.view.rest.model.Direction;
import de.derivo.semspect.server.view.rest.model.Errors;
import de.derivo.semspect.server.view.rest.model.ExpandNodeRequest;
import de.derivo.semspect.server.view.rest.model.GetCategory200Response;
import de.derivo.semspect.server.view.rest.model.GetCategoryExpansionOptions200Response;
import de.derivo.semspect.server.view.rest.model.GetCategoryHistograms200Response;
import de.derivo.semspect.server.view.rest.model.GetCategoryObjectCount200Response;
import de.derivo.semspect.server.view.rest.model.GetDescription200Response;
import de.derivo.semspect.server.view.rest.model.GetNodeDetails200Response;
import de.derivo.semspect.server.view.rest.model.GetNodeDetailsRequest;
import de.derivo.semspect.server.view.rest.model.GetQuery200Response;
import de.derivo.semspect.server.view.rest.model.GetQueryRequest;
import de.derivo.semspect.server.view.rest.model.NodeRequestDTO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="Exploration", description="the Exploration API")
public interface A {
    default public E wG() {
        return new B(this);
    }

    @Operation(operationId="expandNode", summary="Expand the given node according to the specified given arguments.", tags={"Exploration"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetCategory200Response.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/node/{nodeID}/expand/{relationID}/{direction}/{categoryID}"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<GetCategory200Response> a(@NotNull @Parameter(name="maxObjects", description="", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="maxObjects", required=true) Integer n2, @Parameter(name="nodeID", description="", required=true, in=ParameterIn.PATH) @PathVariable(value="nodeID") String string, @Parameter(name="relationID", description="", required=true, in=ParameterIn.PATH) @PathVariable(value="relationID") String string2, @Parameter(name="direction", description="", required=true, in=ParameterIn.PATH) @PathVariable(value="direction") Direction direction, @Parameter(name="categoryID", description="", required=true, in=ParameterIn.PATH) @PathVariable(value="categoryID") String string3, @Parameter(name="lang", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="lang", required=false) @Nullable String string4, @Parameter(name="frontendDataVersion", description="last data version seen by frontend. Used to deduct if the frontend has to refresh.", in=ParameterIn.QUERY) @Valid @RequestParam(value="frontendDataVersion", required=false) @Nullable String string5, @Parameter(name="database", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="database", required=false) @Nullable String string6, @Parameter(name="sessionId", description="Id identifying one session. Used in all non session paths", in=ParameterIn.QUERY) @Valid @RequestParam(value="sessionId", required=false) @Nullable String string7, @Parameter(name="ExpandNodeRequest", description="") @Valid @RequestBody(required=false) @Nullable ExpandNodeRequest expandNodeRequest) {
        return this.wG().a(n2, string, string2, direction, string3, string4, string5, string6, string7, expandNodeRequest);
    }

    @Operation(operationId="getDescription", summary="Get the query for a given node.", tags={"Report"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetDescription200Response.class))}), @ApiResponse(responseCode="400", description="Returned if the tree could not be parsed or a filter was defined on a PredecessorCount column. ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Errors.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/node/{nodeID}/description"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<GetDescription200Response> a(@Parameter(name="nodeID", description="", required=true, in=ParameterIn.PATH) @PathVariable(value="nodeID") String string, @Parameter(name="lang", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="lang", required=false) @Nullable String string2, @Parameter(name="license", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="license", required=false) @Nullable String string3, @Parameter(name="frontendDataVersion", description="last data version seen by frontend. Used to deduct if the frontend has to refresh.", in=ParameterIn.QUERY) @Valid @RequestParam(value="frontendDataVersion", required=false) @Nullable String string4, @Parameter(name="database", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="database", required=false) @Nullable String string5, @Parameter(name="sessionId", description="Id identifying one session. Used in all non session paths", in=ParameterIn.QUERY) @Valid @RequestParam(value="sessionId", required=false) @Nullable String string6, @Parameter(name="GetQueryRequest", description="") @Valid @RequestBody(required=false) @Nullable GetQueryRequest getQueryRequest) {
        return this.wG().a(string, string2, string3, string4, string5, string6, getQueryRequest);
    }

    @Operation(operationId="getNodeDetails", summary="Get the node details for a given node.", tags={"Report"}, responses={@ApiResponse(responseCode="200", description="Done", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetNodeDetails200Response.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/node/{nodeID}"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<GetNodeDetails200Response> a(@Parameter(name="nodeID", description="", required=true, in=ParameterIn.PATH) @PathVariable(value="nodeID") String string, @Parameter(name="lang", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="lang", required=false) @Nullable String string2, @Parameter(name="limit", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="limit", required=false) @Nullable Long l2, @Parameter(name="start", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="start", required=false) @Nullable Long l3, @Parameter(name="sort", description="Index of column to sort starting from 0.", in=ParameterIn.QUERY) @Valid @RequestParam(value="sort", required=false) @Nullable String string3, @Parameter(name="dir", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="dir", required=false) @Nullable String string4, @Parameter(name="frontendDataVersion", description="last data version seen by frontend. Used to deduct if the frontend has to refresh.", in=ParameterIn.QUERY) @Valid @RequestParam(value="frontendDataVersion", required=false) @Nullable String string5, @Parameter(name="database", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="database", required=false) @Nullable String string6, @Parameter(name="sessionId", description="Id identifying one session. Used in all non session paths", in=ParameterIn.QUERY) @Valid @RequestParam(value="sessionId", required=false) @Nullable String string7, @Parameter(name="GetNodeDetailsRequest", description="") @Valid @RequestBody(required=false) @Nullable GetNodeDetailsRequest getNodeDetailsRequest) {
        return this.wG().a(string, string2, l2, l3, string3, string4, string5, string6, string7, getNodeDetailsRequest);
    }

    @Operation(operationId="getNodeDetailsCSV", summary="Get the node details for a given node as csv.", tags={"Report"}, responses={@ApiResponse(responseCode="200", description="Done", content={@Content(mediaType="text/csv", schema=@Schema(implementation=Resource.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/node/{nodeID}/csv"}, produces={"text/csv"}, consumes={"application/json"})
    default public ResponseEntity<Resource> b(@Parameter(name="nodeID", description="", required=true, in=ParameterIn.PATH) @PathVariable(value="nodeID") String string, @Parameter(name="lang", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="lang", required=false) @Nullable String string2, @Parameter(name="limit", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="limit", required=false) @Nullable Long l2, @Parameter(name="start", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="start", required=false) @Nullable Long l3, @Parameter(name="sort", description="Index of column to sort starting from 0.", in=ParameterIn.QUERY) @Valid @RequestParam(value="sort", required=false) @Nullable String string3, @Parameter(name="dir", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="dir", required=false) @Nullable String string4, @Parameter(name="frontendDataVersion", description="last data version seen by frontend. Used to deduct if the frontend has to refresh.", in=ParameterIn.QUERY) @Valid @RequestParam(value="frontendDataVersion", required=false) @Nullable String string5, @Parameter(name="database", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="database", required=false) @Nullable String string6, @Parameter(name="sessionId", description="Id identifying one session. Used in all non session paths", in=ParameterIn.QUERY) @Valid @RequestParam(value="sessionId", required=false) @Nullable String string7, @Parameter(name="GetNodeDetailsRequest", description="") @Valid @RequestBody(required=false) @Nullable GetNodeDetailsRequest getNodeDetailsRequest) {
        return this.wG().b(string, string2, l2, l3, string3, string4, string5, string6, string7, getNodeDetailsRequest);
    }

    @Operation(operationId="getNodeDetailsQuery", summary="Get the node details query for a given node.", tags={"Report"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetQuery200Response.class))}), @ApiResponse(responseCode="400", description="Returned if the tree could not be parsed or a filter was defined on a PredecessorCount column. ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Errors.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/node/{nodeID}/query"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<GetQuery200Response> a(@Parameter(name="nodeID", description="", required=true, in=ParameterIn.PATH) @PathVariable(value="nodeID") String string, @Parameter(name="lang", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="lang", required=false) @Nullable String string2, @Parameter(name="limit", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="limit", required=false) @Nullable Long l2, @Parameter(name="start", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="start", required=false) @Nullable Long l3, @Parameter(name="sort", description="Index of column to sort starting from 0.", in=ParameterIn.QUERY) @Valid @RequestParam(value="sort", required=false) @Nullable String string3, @Parameter(name="dir", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="dir", required=false) @Nullable String string4, @Parameter(name="frontendDataVersion", description="last data version seen by frontend. Used to deduct if the frontend has to refresh.", in=ParameterIn.QUERY) @Valid @RequestParam(value="frontendDataVersion", required=false) @Nullable String string5, @Parameter(name="license", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="license", required=false) @Nullable String string6, @Parameter(name="database", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="database", required=false) @Nullable String string7, @Parameter(name="sessionId", description="Id identifying one session. Used in all non session paths", in=ParameterIn.QUERY) @Valid @RequestParam(value="sessionId", required=false) @Nullable String string8, @Parameter(name="GetNodeDetailsRequest", description="") @Valid @RequestBody(required=false) @Nullable GetNodeDetailsRequest getNodeDetailsRequest) {
        return this.wG().a(string, string2, l2, l3, string3, string4, string5, string6, string7, string8, getNodeDetailsRequest);
    }

    @Operation(operationId="getNodeExpansionOptions", summary="Get the expansion options of a given node.", tags={"Exploration"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetCategoryExpansionOptions200Response.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/node/{nodeID}/expansionoptions"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<GetCategoryExpansionOptions200Response> a(@Parameter(name="nodeID", description="", required=true, in=ParameterIn.PATH) @PathVariable(value="nodeID") String string, @Parameter(name="lang", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="lang", required=false) @Nullable String string2, @Parameter(name="database", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="database", required=false) @Nullable String string3, @Parameter(name="sessionId", description="Id identifying one session. Used in all non session paths", in=ParameterIn.QUERY) @Valid @RequestParam(value="sessionId", required=false) @Nullable String string4, @Parameter(name="NodeRequestDTO", description="") @Valid @RequestBody(required=false) @Nullable NodeRequestDTO nodeRequestDTO) {
        return this.wG().a(string, string2, string3, string4, nodeRequestDTO);
    }

    @Operation(operationId="getNodeHistograms", summary="Get the histograms of the provided node.", tags={"Exploration"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetCategoryHistograms200Response.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/node/{nodeID}/histograms"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<GetCategoryHistograms200Response> b(@Parameter(name="nodeID", description="", required=true, in=ParameterIn.PATH) @PathVariable(value="nodeID") String string, @Parameter(name="lang", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="lang", required=false) @Nullable String string2, @Parameter(name="database", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="database", required=false) @Nullable String string3, @Parameter(name="sessionId", description="Id identifying one session. Used in all non session paths", in=ParameterIn.QUERY) @Valid @RequestParam(value="sessionId", required=false) @Nullable String string4, @Parameter(name="NodeRequestDTO", description="") @Valid @RequestBody(required=false) @Nullable NodeRequestDTO nodeRequestDTO) {
        return this.wG().b(string, string2, string3, string4, nodeRequestDTO);
    }

    @Operation(operationId="getNodeObjectCount", summary="Get the object count of the provided node.", tags={"Exploration"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetCategoryObjectCount200Response.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/node/{nodeID}/objectCount"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<GetCategoryObjectCount200Response> c(@Parameter(name="nodeID", description="", required=true, in=ParameterIn.PATH) @PathVariable(value="nodeID") String string, @Parameter(name="lang", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="lang", required=false) @Nullable String string2, @Parameter(name="database", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="database", required=false) @Nullable String string3, @Parameter(name="sessionId", description="Id identifying one session. Used in all non session paths", in=ParameterIn.QUERY) @Valid @RequestParam(value="sessionId", required=false) @Nullable String string4, @Parameter(name="NodeRequestDTO", description="") @Valid @RequestBody(required=false) @Nullable NodeRequestDTO nodeRequestDTO) {
        return this.wG().c(string, string2, string3, string4, nodeRequestDTO);
    }

    @Operation(operationId="getQuery", summary="Get the query for a given node.", tags={"Report"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetQuery200Response.class))}), @ApiResponse(responseCode="400", description="Returned if the tree could not be parsed or a filter was defined on a PredecessorCount column. ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Errors.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/node/{nodeID}/toQuery"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<GetQuery200Response> b(@Parameter(name="nodeID", description="", required=true, in=ParameterIn.PATH) @PathVariable(value="nodeID") String string, @Parameter(name="lang", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="lang", required=false) @Nullable String string2, @Parameter(name="license", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="license", required=false) @Nullable String string3, @Parameter(name="frontendDataVersion", description="last data version seen by frontend. Used to deduct if the frontend has to refresh.", in=ParameterIn.QUERY) @Valid @RequestParam(value="frontendDataVersion", required=false) @Nullable String string4, @Parameter(name="database", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="database", required=false) @Nullable String string5, @Parameter(name="sessionId", description="Id identifying one session. Used in all non session paths", in=ParameterIn.QUERY) @Valid @RequestParam(value="sessionId", required=false) @Nullable String string6, @Parameter(name="GetQueryRequest", description="") @Valid @RequestBody(required=false) @Nullable GetQueryRequest getQueryRequest) {
        return this.wG().b(string, string2, string3, string4, string5, string6, getQueryRequest);
    }

    @Operation(operationId="rebuildNode", summary="Intended to be used to rebuild a whole tree/subtree on language or maxObject change.", tags={"Exploration"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetCategory200Response.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/node/rebuild"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<GetCategory200Response> a(@NotNull @Parameter(name="maxObjects", description="", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="maxObjects", required=true) Integer n2, @Parameter(name="lang", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="lang", required=false) @Nullable String string, @Parameter(name="frontendDataVersion", description="last data version seen by frontend. Used to deduct if the frontend has to refresh.", in=ParameterIn.QUERY) @Valid @RequestParam(value="frontendDataVersion", required=false) @Nullable String string2, @Parameter(name="database", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="database", required=false) @Nullable String string3, @Parameter(name="sessionId", description="Id identifying one session. Used in all non session paths", in=ParameterIn.QUERY) @Valid @RequestParam(value="sessionId", required=false) @Nullable String string4, @Parameter(name="ExpandNodeRequest", description="") @Valid @RequestBody(required=false) @Nullable ExpandNodeRequest expandNodeRequest) {
        return this.wG().a(n2, string, string2, string3, string4, expandNodeRequest);
    }

    @Operation(operationId="updateNode", summary="Update the specified node.", tags={"Exploration"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetCategory200Response.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/node/{nodeID}/update"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<GetCategory200Response> a(@NotNull @Parameter(name="maxObjects", description="", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="maxObjects", required=true) Integer n2, @Parameter(name="nodeID", description="", required=true, in=ParameterIn.PATH) @PathVariable(value="nodeID") String string, @Parameter(name="lang", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="lang", required=false) @Nullable String string2, @Parameter(name="frontendDataVersion", description="last data version seen by frontend. Used to deduct if the frontend has to refresh.", in=ParameterIn.QUERY) @Valid @RequestParam(value="frontendDataVersion", required=false) @Nullable String string3, @Parameter(name="database", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="database", required=false) @Nullable String string4, @Parameter(name="sessionId", description="Id identifying one session. Used in all non session paths", in=ParameterIn.QUERY) @Valid @RequestParam(value="sessionId", required=false) @Nullable String string5, @Parameter(name="ExpandNodeRequest", description="") @Valid @RequestBody(required=false) @Nullable ExpandNodeRequest expandNodeRequest) {
        return this.wG().a(n2, string, string2, string3, string4, string5, expandNodeRequest);
    }
}

