/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.server.view.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.derivo.semspect.server.view.rest.model.HistogramItem;
import de.derivo.semspect.server.view.rest.model.Ordering;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.lang.Nullable;

public class HistogramDTO {
    @Nullable
    private Ordering defaultOrdering;
    @Nullable
    private String label;
    @Nullable
    private String description;
    @Valid
    @Nullable
    private @Valid List<@Valid HistogramItem> items;

    public HistogramDTO defaultOrdering(@Nullable Ordering ordering) {
        this.defaultOrdering = ordering;
        return this;
    }

    @Valid
    @Schema(name="defaultOrdering", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="defaultOrdering")
    @Nullable
    public Ordering getDefaultOrdering() {
        return this.defaultOrdering;
    }

    public void setDefaultOrdering(@Nullable Ordering ordering) {
        this.defaultOrdering = ordering;
    }

    public HistogramDTO label(@Nullable String string) {
        this.label = string;
        return this;
    }

    @Schema(name="label", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="label")
    @Nullable
    public String getLabel() {
        return this.label;
    }

    public void setLabel(@Nullable String string) {
        this.label = string;
    }

    public HistogramDTO description(@Nullable String string) {
        this.description = string;
        return this;
    }

    @Schema(name="description", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String string) {
        this.description = string;
    }

    public HistogramDTO items(@Nullable List<@Valid HistogramItem> list) {
        this.items = list;
        return this;
    }

    public HistogramDTO addItemsItem(HistogramItem histogramItem) {
        if (this.items == null) {
            this.items = new ArrayList<HistogramItem>();
        }
        this.items.add(histogramItem);
        return this;
    }

    @Valid
    @Schema(name="items", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="items")
    @Nullable
    public @Valid List<@Valid HistogramItem> getItems() {
        return this.items;
    }

    public void setItems(@Nullable List<@Valid HistogramItem> list) {
        this.items = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HistogramDTO histogramDTO = (HistogramDTO)object;
        return Objects.equals((Object)this.defaultOrdering, (Object)histogramDTO.defaultOrdering) && Objects.equals(this.label, histogramDTO.label) && Objects.equals(this.description, histogramDTO.description) && Objects.equals(this.items, histogramDTO.items);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.defaultOrdering, this.label, this.description, this.items});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class HistogramDTO {\n");
        stringBuilder.append("    defaultOrdering: ").append(this.toIndentedString((Object)this.defaultOrdering)).append("\n");
        stringBuilder.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        stringBuilder.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        stringBuilder.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

