/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.server.view.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.derivo.semspect.server.view.rest.model.Value;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.lang.Nullable;

public class HistogramItem {
    @Nullable
    private Value category;
    @Nullable
    private Long objectCount;
    @Nullable
    private Long lexicographicOrder;
    @Valid
    private @Valid List<@Valid HistogramItem> subItems = new ArrayList<HistogramItem>();

    public HistogramItem category(@Nullable Value value) {
        this.category = value;
        return this;
    }

    @Valid
    @Schema(name="category", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="category")
    @Nullable
    public Value getCategory() {
        return this.category;
    }

    public void setCategory(@Nullable Value value) {
        this.category = value;
    }

    public HistogramItem objectCount(@Nullable Long l2) {
        this.objectCount = l2;
        return this;
    }

    @Schema(name="objectCount", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="objectCount")
    @Nullable
    public Long getObjectCount() {
        return this.objectCount;
    }

    public void setObjectCount(@Nullable Long l2) {
        this.objectCount = l2;
    }

    public HistogramItem lexicographicOrder(@Nullable Long l2) {
        this.lexicographicOrder = l2;
        return this;
    }

    @Schema(name="lexicographicOrder", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="lexicographicOrder")
    @Nullable
    public Long getLexicographicOrder() {
        return this.lexicographicOrder;
    }

    public void setLexicographicOrder(@Nullable Long l2) {
        this.lexicographicOrder = l2;
    }

    public HistogramItem subItems(List<@Valid HistogramItem> list) {
        this.subItems = list;
        return this;
    }

    public HistogramItem addSubItemsItem(HistogramItem histogramItem) {
        if (this.subItems == null) {
            this.subItems = new ArrayList<HistogramItem>();
        }
        this.subItems.add(histogramItem);
        return this;
    }

    @Valid
    @Schema(name="subItems", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="subItems")
    public @Valid List<@Valid HistogramItem> getSubItems() {
        return this.subItems;
    }

    public void setSubItems(List<@Valid HistogramItem> list) {
        this.subItems = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HistogramItem histogramItem = (HistogramItem)object;
        return Objects.equals(this.category, histogramItem.category) && Objects.equals(this.objectCount, histogramItem.objectCount) && Objects.equals(this.lexicographicOrder, histogramItem.lexicographicOrder) && Objects.equals(this.subItems, histogramItem.subItems);
    }

    public int hashCode() {
        return Objects.hash(this.category, this.objectCount, this.lexicographicOrder, this.subItems);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class HistogramItem {\n");
        stringBuilder.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        stringBuilder.append("    objectCount: ").append(this.toIndentedString(this.objectCount)).append("\n");
        stringBuilder.append("    lexicographicOrder: ").append(this.toIndentedString(this.lexicographicOrder)).append("\n");
        stringBuilder.append("    subItems: ").append(this.toIndentedString(this.subItems)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

