/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.server.view.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import de.derivo.semspect.server.view.rest.model.Database;
import de.derivo.semspect.server.view.rest.model.LicenseConfiguration;
import de.derivo.semspect.server.view.rest.model.Settings;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.lang.Nullable;

@JsonTypeName(value="Configuration")
public class ModelConfiguration {
    @Nullable
    private Long version;
    @Nullable
    private Settings settings;
    @Nullable
    private LicenseConfiguration license;
    @Valid
    @Nullable
    private @Valid List<@Valid Database> databases;

    public ModelConfiguration version(@Nullable Long l2) {
        this.version = l2;
        return this;
    }

    @Schema(name="version", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="version")
    @Nullable
    public Long getVersion() {
        return this.version;
    }

    public void setVersion(@Nullable Long l2) {
        this.version = l2;
    }

    public ModelConfiguration settings(@Nullable Settings settings) {
        this.settings = settings;
        return this;
    }

    @Valid
    @Schema(name="settings", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="settings")
    @Nullable
    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(@Nullable Settings settings) {
        this.settings = settings;
    }

    public ModelConfiguration license(@Nullable LicenseConfiguration licenseConfiguration) {
        this.license = licenseConfiguration;
        return this;
    }

    @Valid
    @Schema(name="license", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="license")
    @Nullable
    public LicenseConfiguration getLicense() {
        return this.license;
    }

    public void setLicense(@Nullable LicenseConfiguration licenseConfiguration) {
        this.license = licenseConfiguration;
    }

    public ModelConfiguration databases(@Nullable List<@Valid Database> list) {
        this.databases = list;
        return this;
    }

    public ModelConfiguration addDatabasesItem(Database database) {
        if (this.databases == null) {
            this.databases = new ArrayList<Database>();
        }
        this.databases.add(database);
        return this;
    }

    @Valid
    @Schema(name="databases", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="databases")
    @Nullable
    public @Valid List<@Valid Database> getDatabases() {
        return this.databases;
    }

    public void setDatabases(@Nullable List<@Valid Database> list) {
        this.databases = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ModelConfiguration modelConfiguration = (ModelConfiguration)object;
        return Objects.equals(this.version, modelConfiguration.version) && Objects.equals(this.settings, modelConfiguration.settings) && Objects.equals(this.license, modelConfiguration.license) && Objects.equals(this.databases, modelConfiguration.databases);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.settings, this.license, this.databases);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class ModelConfiguration {\n");
        stringBuilder.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        stringBuilder.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        stringBuilder.append("    license: ").append(this.toIndentedString(this.license)).append("\n");
        stringBuilder.append("    databases: ").append(this.toIndentedString(this.databases)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

