/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.store.exploration.statistics;

import de.derivo.a.i.a.u;
import de.derivo.a.i.a.x;
import de.derivo.semspect.store.exploration.statistics.DescriptiveStats;
import de.derivo.semspect.store.exploration.statistics.HierarchyLevelWithValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class RDFClassHierarchyStats {
    private transient u rch;
    private long numberOfRDFClasses;
    private long numberOfRDFClassNodesInHierarchy;
    private int hierarchyDepth;
    private DescriptiveStats rdfClassesPerNode;
    private DescriptiveStats childrenPerRDFClassNode;
    private List<HierarchyLevelWithValue> rdfClassNodesPerLevel;
    private List<HierarchyLevelWithValue> rdfClassesPerNodePerLevel;

    protected RDFClassHierarchyStats() {
    }

    public RDFClassHierarchyStats(u u2) {
        this.rch = u2;
        this.init();
    }

    private void init() {
        Object object;
        this.numberOfRDFClasses = this.rch.hz().size();
        this.numberOfRDFClassNodesInHierarchy = this.rch.hF().keySet().size();
        this.hierarchyDepth = this.rch.hC();
        this.rdfClassNodesPerLevel = new ArrayList<HierarchyLevelWithValue>(this.hierarchyDepth);
        this.rdfClassesPerNodePerLevel = new ArrayList<HierarchyLevelWithValue>(this.hierarchyDepth);
        for (int i2 = 1; i2 <= this.hierarchyDepth; ++i2) {
            object = this.rch.d(i2, i2);
            double[] dArray = object.stream().map(x::gg).mapToDouble(set -> set.size()).toArray();
            DescriptiveStatistics descriptiveStatistics = new DescriptiveStatistics(dArray);
            this.rdfClassesPerNodePerLevel.add(new HierarchyLevelWithValue(i2, new DescriptiveStats(descriptiveStatistics)));
        }
        double[] dArray = this.rch.hF().values().stream().map(x::gg).mapToDouble(Set::size).toArray();
        this.rdfClassesPerNode = new DescriptiveStats(new DescriptiveStatistics(dArray));
        object = this.rch.hF().values().stream().map(x::ge).mapToDouble(Set::size).toArray();
        this.childrenPerRDFClassNode = new DescriptiveStats(new DescriptiveStatistics((double[])object));
    }

    public long getNumberOfRDFClasses() {
        return this.numberOfRDFClasses;
    }

    public long getNumberOfRDFClassNodesInHierarchy() {
        return this.numberOfRDFClassNodesInHierarchy;
    }

    public int getHierarchyDepth() {
        return this.hierarchyDepth;
    }

    public DescriptiveStats getChildrenPerRDFClassNode() {
        return this.childrenPerRDFClassNode;
    }

    public List<HierarchyLevelWithValue> getRdfClassNodesPerLevel() {
        return this.rdfClassNodesPerLevel;
    }

    public List<HierarchyLevelWithValue> getRdfClassesPerNodePerLevel() {
        return this.rdfClassesPerNodePerLevel;
    }

    public DescriptiveStats getRdfClassesPerNode() {
        return this.rdfClassesPerNode;
    }
}

