/*
 * Decompiled with CFR 0.152.
 */
package de.derivo.semspect.store.exploration.statistics;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.io.Files;
import de.derivo.a.b.a;
import de.derivo.a.k.b.c;
import de.derivo.a.k.b.d;
import de.derivo.a.k.l.b;
import de.derivo.a.k.o;
import de.derivo.semspect.store.b.m;
import de.derivo.semspect.store.exploration.h;
import de.derivo.semspect.store.exploration.statistics.CtCIndicesStats;
import de.derivo.semspect.store.exploration.statistics.DatasetStats;
import de.derivo.semspect.store.exploration.statistics.MemoryConsumptionStats;
import de.derivo.semspect.store.exploration.statistics.PVIndicesStats;
import de.derivo.semspect.store.exploration.statistics.PropertyHierarchyStats;
import de.derivo.semspect.store.exploration.statistics.PropertyManagerStats;
import de.derivo.semspect.store.exploration.statistics.RDFClassHierarchyWithInstancesStats;
import de.derivo.semspect.store.exploration.statistics.StringLiteralLanguageSortingIndexStats;
import java.nio.file.Path;

public class SemSpectExplorationStats {
    public static final String NAME = "semSpectExplorationStats";
    private transient h semSpectExp;
    private transient a dataset;
    private String explorationDirectoryName;
    private DatasetStats datasetStats;
    private c consideredTriples;
    private d generationApproach;
    private RDFClassHierarchyWithInstancesStats rdfClassHierarchyStats;
    private PropertyManagerStats propertyManagerStats;
    private CtCIndicesStats ctcIndicesStats;
    private PVIndicesStats pvIndicesStats;
    private StringLiteralLanguageSortingIndexStats languageStats;
    private PropertyHierarchyStats propertyHierarchyStats;
    private MemoryConsumptionStats memoryConsumptionStats;
    private String version;
    private long initializationTimeInMS;

    private SemSpectExplorationStats() {
    }

    public SemSpectExplorationStats(h h2, a a2, Path path, d d2, MemoryConsumptionStats memoryConsumptionStats, String string, long l2) {
        this.semSpectExp = h2;
        this.dataset = a2;
        this.consideredTriples = a2.getConsideredTriples();
        this.explorationDirectoryName = Files.getNameWithoutExtension((String)path.toString());
        this.generationApproach = d2;
        this.memoryConsumptionStats = memoryConsumptionStats;
        this.version = string;
        this.initializationTimeInMS = l2;
        this.init();
    }

    private void init() {
        this.datasetStats = new DatasetStats(this.dataset);
        this.rdfClassHierarchyStats = new RDFClassHierarchyWithInstancesStats(this.semSpectExp.cb(), this.semSpectExp.xc());
        this.propertyManagerStats = new PropertyManagerStats(this.semSpectExp.xb(), this.semSpectExp.xc());
        this.ctcIndicesStats = new CtCIndicesStats(this.semSpectExp.xd());
        this.pvIndicesStats = new PVIndicesStats(this.semSpectExp.xe());
        this.propertyHierarchyStats = new PropertyHierarchyStats(this.semSpectExp.xl());
        if (this.semSpectExp.xk() != null) {
            this.languageStats = new StringLiteralLanguageSortingIndexStats(this.semSpectExp.xk());
        }
    }

    public String getExplorationDirectoryName() {
        return this.explorationDirectoryName;
    }

    public DatasetStats getDatasetStats() {
        return this.datasetStats;
    }

    @JsonProperty(value="rdfClassHierarchyStats")
    public RDFClassHierarchyWithInstancesStats getRDFClassHierarchyStats() {
        return this.rdfClassHierarchyStats;
    }

    public PropertyManagerStats getPropertyManagerStats() {
        return this.propertyManagerStats;
    }

    @JsonProperty(value="ctcIndicesStats")
    public CtCIndicesStats getCtCIndicesStats() {
        return this.ctcIndicesStats;
    }

    @JsonProperty(value="pvIndicesStats")
    public PVIndicesStats getPVIndicesStats() {
        return this.pvIndicesStats;
    }

    public StringLiteralLanguageSortingIndexStats getLanguageStats() {
        return this.languageStats;
    }

    public c getConsideredTriples() {
        return this.consideredTriples;
    }

    public String getVersion() {
        return this.version;
    }

    public long getInitializationTimeInMS() {
        return this.initializationTimeInMS;
    }

    public MemoryConsumptionStats getMemoryConsumptionStats() {
        return this.memoryConsumptionStats;
    }

    public d getGenerationApproach() {
        return this.generationApproach;
    }

    public PropertyHierarchyStats getPropertyHierarchyStats() {
        return this.propertyHierarchyStats;
    }

    public void write(Path path) {
        b.a(m.jD(), path, this);
    }

    public void writeAsYAML(Path path) {
        o.a(path, this);
    }

    public static SemSpectExplorationStats load(Path path) {
        return (SemSpectExplorationStats)b.a(m.jD(), path);
    }
}

