/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.cdt;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.apache.jena.cdt.CDTKey;
import org.apache.jena.cdt.CDTLiteralParseException;
import org.apache.jena.cdt.CDTValue;
import org.apache.jena.cdt.parser.CDTLiteralParser;
import org.apache.jena.cdt.parser.ParseException;
import org.apache.jena.cdt.parser.TokenMgrError;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.RiotLib;

public class ParserForCDTLiterals {
    public static List<CDTValue> parseListLiteral(String lex) {
        return ParserForCDTLiterals.parseListLiteral(RiotLib.dftProfile(), lex);
    }

    public static List<CDTValue> parseListLiteral(ParserProfile pp, String lex) {
        List<CDTValue> list;
        StringReader reader = new StringReader(lex);
        try {
            list = ParserForCDTLiterals.parseListLiteral(pp, reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e2) {
                throw new CDTLiteralParseException("Closing the reader caused an exception.", e2);
            }
        }
        ((Reader)reader).close();
        return list;
    }

    public static List<CDTValue> parseListLiteral(Reader reader) {
        return ParserForCDTLiterals.parseListLiteral(RiotLib.dftProfile(), reader);
    }

    public static List<CDTValue> parseListLiteral(ParserProfile pp, Reader reader) {
        List<CDTValue> list;
        CDTLiteralParser parser = new CDTLiteralParser(reader);
        parser.setProfile(pp);
        try {
            list = parser.List();
        }
        catch (ParseException | TokenMgrError ex) {
            throw new CDTLiteralParseException(ex.getMessage());
        }
        catch (CDTLiteralParseException ex) {
            throw ex;
        }
        catch (Throwable th) {
            throw new CDTLiteralParseException(th.getMessage(), th);
        }
        return list;
    }

    public static Map<CDTKey, CDTValue> parseMapLiteral(String lex) {
        return ParserForCDTLiterals.parseMapLiteral(RiotLib.dftProfile(), lex);
    }

    public static Map<CDTKey, CDTValue> parseMapLiteral(ParserProfile pp, String lex) {
        Map<CDTKey, CDTValue> map;
        StringReader reader = new StringReader(lex);
        try {
            map = ParserForCDTLiterals.parseMapLiteral(pp, reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e2) {
                throw new CDTLiteralParseException("Closing the reader caused an exception.", e2);
            }
        }
        ((Reader)reader).close();
        return map;
    }

    public static Map<CDTKey, CDTValue> parseMapLiteral(Reader reader) {
        return ParserForCDTLiterals.parseMapLiteral(RiotLib.dftProfile(), reader);
    }

    public static Map<CDTKey, CDTValue> parseMapLiteral(ParserProfile pp, Reader reader) {
        Map<CDTKey, CDTValue> map;
        CDTLiteralParser parser = new CDTLiteralParser(reader);
        parser.setProfile(pp);
        try {
            map = parser.Map();
        }
        catch (ParseException | TokenMgrError ex) {
            throw new CDTLiteralParseException(ex.getMessage());
        }
        catch (CDTLiteralParseException ex) {
            throw ex;
        }
        catch (Throwable th) {
            throw new CDTLiteralParseException(th.getMessage(), th);
        }
        return map;
    }
}

