/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang.rdfxml.rrx;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.atlas.lib.EscapeStr;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.impl.XMLLiteralType;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIx;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.lang.rdfxml.RDFXMLParseException;
import org.apache.jena.riot.lang.rdfxml.rrx.ReaderRDFXML_SAX;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.util.XML11Char;
import org.apache.jena.vocabulary.RDF;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.EntityResolver2;
import org.xml.sax.ext.LexicalHandler;

class ParserRRX_SAX
implements ContentHandler,
org.xml.sax.ErrorHandler,
EntityResolver,
DTDHandler,
LexicalHandler,
DeclHandler,
EntityResolver2 {
    private static int IRI_CACHE_SIZE = 8192;
    private static boolean VERBOSE = false;
    private static boolean EVENTS = false;
    private final IndentedWriter trace;
    private final IndentedWriter traceXML;
    private static final String rdfNS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String xmlNS = "http://www.w3.org/XML/1998/namespace";
    private static final String rdfRDF = "RDF";
    private static final String rdfDescription = "Description";
    private static final String rdfID = "ID";
    private static final String rdfNodeID = "nodeID";
    private static final String rdfAbout = "about";
    private static final String rdfType = "type";
    private static final String rdfSeq = "Seq";
    private static final String rdfBag = "Bag";
    private static final String rdfAlt = "Alt";
    private static final String rdfDatatype = "datatype";
    private static final String rdfParseType = "parseType";
    private static final String rdfResource = "resource";
    private static final String rdfContainerItem = "li";
    private static final String rdfAboutEach = "aboutEach";
    private static final String rdfAboutEachPrefix = "aboutEachPrefix";
    private static final String rdfBagID = "bagID";
    private static final RDFDatatype rdfXmlLiteralDT = XMLLiteralType.rdfXMLLiteral;
    private static final String xmlBaseLN = "base";
    private static final String xmlLangLN = "lang";
    private static final String xmlSpaceLN = "space";
    private static Set<String> $coreSyntaxTerms = Set.of("RDF", "ID", "about", "parseType", "resource", "nodeID", "datatype");
    private static Set<String> $syntaxTerms = Set.of("RDF", "ID", "about", "parseType", "resource", "nodeID", "datatype", "Description", "li");
    private static Set<String> $oldTerms = Set.of("aboutEach", "aboutEachPrefix", "bagID");
    private static Set<String> $allowedUnqualified = Set.of("about", "ID", "resource", "parseType", "type");
    private static Set<String> $rdfSyntaxAttributes = Set.of("RDF", "about", "nodeID", "ID", "parseType", "datatype", "resource");
    private static Set<String> $xmlReservedTerms = Set.of("base", "lang", "space");
    private Deque<ParserFrame> parserStack = new ArrayDeque<ParserFrame>();
    private final ParserProfile parserProfile;
    private final Context context;
    private final ErrorHandler errorHandler;
    private final String initialXmlBase;
    private final String initialXmlLang;
    private final StreamRDF destination;
    private Cache<String, IRIx> iriCacheForBaseNull = null;
    private Cache<String, IRIx> currentIriCache = null;
    private final Map<IRIx, Cache<String, IRIx>> mapBaseIriToCache = new HashMap<IRIx, Cache<String, IRIx>>();
    private int countTrackingIDs = 0;
    private Map<IRIx, Map<String, Position>> trackUsedIDs = new HashMap<IRIx, Map<String, Position>>();
    private Locator locator = null;
    private boolean hasRDF = false;
    private boolean hasDocument = false;
    private RDFDatatype datatype;
    private StringBuilder accCharacters = new StringBuilder(100);
    private int elementDepth = 0;
    private int xmlLiteralStartDepth = -1;
    private IRIx currentBase;
    private String currentLang = null;
    private Node currentSubject = null;
    private Node currentProperty = null;
    private Counter containerPropertyCounter = null;
    private NodeHolder collectionNode = null;
    private Emitter currentEmitter = null;
    private ParserMode parserMode = ParserMode.TOP;
    private static final Set<String> knownRDF = Set.of("Bag", "Seq", "Alt", "List", "XMLLiteral", "Property", "Statement", "type", "li", "subject", "predicate", "object", "value", "first", "rest", "nil");
    private static final Set<String> knownRDFProperties = knownRDF;
    private static final Set<String> knownRDFTypes = knownRDF;
    private static final String openStartTag = "<";
    private static final String closeStartTag = ">";
    private static final String openEndTag = "</";
    private static final String closeEndTag = ">";
    private Map<String, String> namespaces = Map.of();
    private Deque<Map<String, String>> stackNamespaces = new ArrayDeque<Map<String, String>>();

    private boolean coreSyntaxTerm(String namespace2, String localName) {
        if (!rdfNS.equals(namespace2)) {
            return false;
        }
        return $coreSyntaxTerms.contains(localName);
    }

    private static boolean allowedNodeElementURIs(String namespace2, String localName) {
        if (!rdfNS.equals(namespace2)) {
            return true;
        }
        if ($coreSyntaxTerms.contains(localName)) {
            return false;
        }
        if (rdfContainerItem.equals(localName)) {
            return false;
        }
        return !$oldTerms.contains(localName);
    }

    private static boolean allowedPropertyElementURIs(String namespace2, String localName) {
        if (!rdfNS.equals(namespace2)) {
            return true;
        }
        if ($coreSyntaxTerms.contains(localName)) {
            return false;
        }
        if (rdfDescription.equals(localName)) {
            return false;
        }
        return !$oldTerms.contains(localName);
    }

    private static boolean allowedPropertyAttributeURIs(String namespace2, String localName) {
        if (!rdfNS.equals(namespace2)) {
            return true;
        }
        if ($coreSyntaxTerms.contains(localName)) {
            return false;
        }
        if (rdfDescription.equals(localName)) {
            return false;
        }
        if (rdfContainerItem.equals(localName)) {
            return false;
        }
        return !$oldTerms.contains(localName);
    }

    private static boolean allowedUnqualifiedTerm(String localName) {
        return $allowedUnqualified.contains(localName);
    }

    private static boolean isSyntaxAttribute(String namespace2, String localName) {
        if (!ParserRRX_SAX.isXMLNamespace(namespace2)) {
            return false;
        }
        return $rdfSyntaxAttributes.contains(localName);
    }

    private static boolean isXMLQName(String namespace2, String localName) {
        if (!ParserRRX_SAX.isXMLNamespace(namespace2)) {
            return false;
        }
        return $xmlReservedTerms.contains(localName);
    }

    private static boolean isXMLNamespace(String namespace2) {
        return xmlNS.equals(namespace2);
    }

    private static boolean isXMLNamespaceQName(String qName) {
        return qName != null && (qName.equals("xmlns") || qName.startsWith("xmlns:"));
    }

    private static String str(Position position) {
        if (position == null) {
            return "[-,-]";
        }
        if (position.line() < 0 && position.column() < 0) {
            return "[?,?]";
        }
        if (position.column() < 0) {
            return String.format("[-, Col: %d]", position.line());
        }
        if (position.line() < 0) {
            return String.format("[Line: %d, -]", position.column());
        }
        return String.format("[Line: %d, Col: %d]", position.line(), position.column());
    }

    private void pushParserFrame() {
        this.pushParserFrame(this.parserMode);
    }

    private void pushParserFrame(ParserMode frameParserMode) {
        if (ReaderRDFXML_SAX.TRACE) {
            this.trace.printf("Push frame: S: %s P: %s -- mode=%s\n", new Object[]{ParserRRX_SAX.str(this.currentSubject), ParserRRX_SAX.str(this.currentProperty), frameParserMode});
        }
        ParserFrame frame = new ParserFrame(this.currentBase, this.currentLang, this.currentSubject, this.currentProperty, this.containerPropertyCounter, this.collectionNode, this.currentEmitter, frameParserMode, this.currentIriCache);
        this.parserStack.push(frame);
    }

    private void popParserFrame() {
        ParserFrame frame = this.parserStack.pop();
        if (ReaderRDFXML_SAX.TRACE) {
            this.trace.printf("Pop frame: S: %s -> %s : P: %s -> %s\n", new Object[]{ParserRRX_SAX.str(this.currentSubject), frame.subject, ParserRRX_SAX.str(this.currentProperty), frame.property});
        }
        if (this.isDifferentFromCurrentBase(frame.base)) {
            this.currentBase = frame.base;
            this.currentIriCache = frame.iriCache;
        }
        this.currentLang = frame.lang;
        this.currentSubject = frame.subject;
        this.currentProperty = frame.property;
        this.currentEmitter = frame.emitter;
        this.collectionNode = frame.collectionNode;
        this.containerPropertyCounter = frame.containerPropertyCounter;
        this.parserMode = frame.parserMode;
        if (this.parserMode == ParserMode.ObjectParseTypeResource) {
            this.popParserFrame();
            this.decIndent();
        }
    }

    private static String str(Node node) {
        if (node == null) {
            return "null";
        }
        return NodeFmtLib.displayStr(node);
    }

    private RiotException RDFXMLparseError(String message, Position position) {
        if (position != null) {
            this.errorHandler.error(message, position.line(), position.column());
        } else {
            this.errorHandler.error(message, -1L, -1L);
        }
        return new RiotException(SysRIOT.fmtMessage(message, position.line(), position.column()));
    }

    private void RDFXMLparseWarning(String message, Position position) {
        if (position != null) {
            this.errorHandler.warning(message, position.line(), position.column());
        } else {
            this.errorHandler.warning(message, -1L, -1L);
        }
    }

    private void updateCurrentIriCacheForCurrentBase() {
        if (this.currentBase != null) {
            this.currentIriCache = this.mapBaseIriToCache.computeIfAbsent(this.currentBase, b -> CacheFactory.createSimpleCache((int)IRI_CACHE_SIZE));
        } else {
            if (this.iriCacheForBaseNull == null) {
                this.iriCacheForBaseNull = CacheFactory.createSimpleCache((int)IRI_CACHE_SIZE);
            }
            this.currentIriCache = this.iriCacheForBaseNull;
        }
    }

    private boolean isDifferentFromCurrentBase(IRIx base) {
        if (this.currentBase != null) {
            return !this.currentBase.equals((Object)base);
        }
        return base != null;
    }

    private Position previousUseOfID(String idStr, Position position) {
        Map scope = this.trackUsedIDs.computeIfAbsent(this.currentBase, k -> new HashMap());
        Position prev = (Position)scope.get(idStr);
        if (prev != null) {
            return prev;
        }
        if (this.countTrackingIDs > 10000) {
            return null;
        }
        scope.put(idStr, position);
        ++this.countTrackingIDs;
        return null;
    }

    private void incElementDepth() {
        if (ReaderRDFXML_SAX.TRACE && VERBOSE) {
            this.trace.printf("~~ incElementDepth %d -> %d\n", new Object[]{this.elementDepth, this.elementDepth + 1});
        }
        ++this.elementDepth;
    }

    private void decElementDepth() {
        if (ReaderRDFXML_SAX.TRACE && VERBOSE) {
            this.trace.printf("~~ decElementDepth %d -> %d\n", new Object[]{this.elementDepth, this.elementDepth - 1});
        }
        --this.elementDepth;
    }

    private void parserMode(ParserMode parserMode) {
        this.parserMode = parserMode;
    }

    ParserRRX_SAX(String xmlBase, ParserProfile parserProfile, StreamRDF destination, Context context2) {
        if (ReaderRDFXML_SAX.TRACE) {
            IndentedWriter out1 = IndentedWriter.stdout.clone();
            out1.setFlushOnNewline(true);
            out1.setUnitIndent(4);
            out1.setLinePrefix("# ");
            this.trace = out1;
        } else {
            this.trace = null;
        }
        this.traceXML = this.trace;
        EVENTS = ReaderRDFXML_SAX.TRACE;
        this.parserProfile = parserProfile;
        this.errorHandler = parserProfile.getErrorHandler();
        this.context = context2;
        this.initialXmlBase = xmlBase;
        this.initialXmlLang = "";
        if (xmlBase != null) {
            this.currentBase = IRIx.create((String)xmlBase);
            parserProfile.setBaseIRI(this.currentBase.str());
        } else {
            this.currentBase = null;
        }
        this.updateCurrentIriCacheForCurrentBase();
        this.currentLang = "";
        this.destination = destination;
    }

    @Override
    public void startDocument() throws SAXException {
        if (ReaderRDFXML_SAX.TRACE) {
            this.traceXML.println("Doc start");
        }
        this.hasDocument = true;
    }

    @Override
    public void endDocument() throws SAXException {
        if (ReaderRDFXML_SAX.TRACE) {
            this.traceXML.println("Doc end");
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
        if (this.xmlLiteralCollecting()) {
            if (ReaderRDFXML_SAX.TRACE) {
                this.trace.printf("startElement: XML Literal[%s]: depth = %d\n", new Object[]{qName, this.elementDepth});
            }
            this.xmlLiteralCollectStartElement(namespaceURI, localName, qName, attributes);
            return;
        }
        if (ReaderRDFXML_SAX.TRACE) {
            this.trace.printf("%s StartElement(%s", new Object[]{this.here(), qName});
            for (int i = 0; i < attributes.getLength(); ++i) {
                String x = attributes.getQName(i);
                String v = attributes.getValue(i);
                this.trace.printf(", %s=%s", new Object[]{x, attributes.getValue(i)});
            }
            this.trace.printf(") mode = %s\n", new Object[]{this.parserMode});
        }
        this.incIndent();
        Position position = this.position();
        if (ReaderRDFXML_SAX.TRACE) {
            this.trace.printf("StartElement parserMode=%s\n", new Object[]{this.parserMode});
        }
        switch (this.parserMode) {
            case ObjectLex: {
                if (!ParserRRX_SAX.isWhitespace(this.accCharacters)) {
                    throw this.RDFXMLparseError("XML content before nested element", position);
                }
                this.accCharacters.setLength(0);
                this.pushParserFrame(ParserMode.ObjectNode);
                this.processBaseAndLang(attributes, position);
                break;
            }
            case ObjectNode: {
                throw this.RDFXMLparseError("Start tag after inner node element (only one node element permitted): got " + qName, position);
            }
            default: {
                this.pushParserFrame();
                this.processBaseAndLang(attributes, position);
            }
        }
        switch (this.parserMode) {
            case TOP: {
                if (this.qNameMatches(rdfNS, rdfRDF, namespaceURI, localName)) {
                    this.processBaseAndLang(attributes, position);
                    this.rdfRDF(namespaceURI, localName, qName, attributes, position);
                    return;
                }
                this.startNodeElement(namespaceURI, localName, qName, attributes, position);
                break;
            }
            case ObjectNode: 
            case NodeElement: {
                this.startNodeElement(namespaceURI, localName, qName, attributes, position);
                break;
            }
            case PropertyElement: {
                this.startPropertyElement(namespaceURI, localName, qName, attributes, position);
                break;
            }
            case ObjectLex: {
                Node innerSubject = this.attributesToSubjectNode(attributes, position);
                this.currentEmitter.emit(this.currentSubject, this.currentProperty, innerSubject, position);
                this.startNodeElementWithSubject(innerSubject, namespaceURI, localName, qName, attributes, position);
                break;
            }
            case ObjectParseTypeLiteral: {
                throw this.RDFXMLparseError("Unexpected parserMode " + String.valueOf((Object)this.parserMode), position);
            }
            case ObjectParseTypeCollection: {
                this.startCollectionItem(namespaceURI, localName, qName, attributes, position);
                break;
            }
        }
        this.incElementDepth();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        if (this.qNameMatches(rdfNS, rdfRDF, namespaceURI, localName)) {
            this.decIndent();
            this.parserMode(ParserMode.TOP);
            return;
        }
        if (ReaderRDFXML_SAX.TRACE) {
            this.decIndent();
            this.trace.printf("%s enter endElement(%s) mode = %s\n", new Object[]{this.here(), qName, this.parserMode});
            this.incIndent();
        }
        Position position = this.position();
        if (this.xmlLiteralCollecting()) {
            if (ReaderRDFXML_SAX.TRACE) {
                this.trace.printf("Collecting: elementDepth=%d / xmlLiteralStartDepth=%s\n", new Object[]{this.elementDepth, this.xmlLiteralStartDepth});
            }
            if (this.elementDepth - 1 > this.xmlLiteralStartDepth) {
                if (ReaderRDFXML_SAX.TRACE) {
                    this.trace.print("Continue collecting\n");
                }
                this.xmlLiteralCollectEndElement(namespaceURI, localName, qName);
                return;
            }
            this.endXMLLiteral(position);
        }
        switch (this.parserMode) {
            case ObjectNode: 
            case NodeElement: {
                this.endNodeElement(position);
                break;
            }
            case PropertyElement: {
                if (this.isEndNodeElement()) {
                    this.endNodeElement(position);
                    break;
                }
                this.endPropertyElement(position);
                break;
            }
            case ObjectLex: {
                this.endObjectLexical(position);
                break;
            }
            case ObjectParseTypeLiteral: {
                this.endObjectXMLLiteral(position);
                break;
            }
            case ObjectParseTypeCollection: {
                this.endCollectionItem(position);
                break;
            }
            default: {
                throw this.RDFXMLparseError("Inconsistent parserMode:" + String.valueOf((Object)this.parserMode), position);
            }
        }
        this.popParserFrame();
        this.decIndent();
        this.decElementDepth();
        if (ReaderRDFXML_SAX.TRACE) {
            this.trace.printf("%s EndElement(%s) mode = %s\n", new Object[]{this.here(), qName, this.parserMode});
        }
    }

    private void rdfRDF(String namespaceURI, String localName, String qName, Attributes attributes, Position position) {
        if (ReaderRDFXML_SAX.TRACE) {
            this.trace.println("rdf:RDF");
        }
        if (this.hasRDF) {
            throw this.RDFXMLparseError("Nested rdf:RDF", position);
        }
        if (this.elementDepth != 0) {
            throw this.RDFXMLparseError("rdf:RDF not at top level", position);
        }
        String xmlBaseURI = attributes.getValue(xmlNS, xmlBaseLN);
        if (xmlBaseURI != null) {
            this.emitBase(xmlBaseURI, position);
            IRIx newBase = this.resolveIRIx(xmlBaseURI, position);
            if (!newBase.equals((Object)this.currentBase)) {
                this.currentBase = newBase;
                this.updateCurrentIriCacheForCurrentBase();
            }
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String prefixURI;
            String prefix;
            String x = attributes.getQName(i);
            if (!x.startsWith("xmlns")) continue;
            if (x.equals("xmlns")) {
                prefix = "";
                prefixURI = attributes.getValue(i);
                this.emitPrefix(prefix, prefixURI, position);
                continue;
            }
            if (!x.startsWith("xmlns:")) continue;
            prefix = x.substring("xmlns:".length());
            prefixURI = attributes.getValue(i);
            this.emitPrefix(prefix, prefixURI, position);
        }
        this.hasRDF = true;
        this.parserMode(ParserMode.NodeElement);
    }

    private void startNodeElement(String namespaceURI, String localName, String qName, Attributes attributes, Position position) {
        String rdfResourceStr = attributes.getValue(rdfNS, rdfResource);
        if (rdfResourceStr != null) {
            throw this.RDFXMLparseError("rdf:resource not allowed as attribute here: " + qName, position);
        }
        Node thisSubject = this.attributesToSubjectNode(attributes, position);
        this.startNodeElementWithSubject(thisSubject, namespaceURI, localName, qName, attributes, position);
    }

    private void startNodeElementWithSubject(Node thisSubject, String namespaceURI, String localName, String qName, Attributes attributes, Position position) {
        if (ReaderRDFXML_SAX.TRACE) {
            this.trace.printf("Start nodeElement: subject = %s\n", new Object[]{ParserRRX_SAX.str(thisSubject)});
        }
        this.currentSubject = thisSubject;
        this.containerPropertyCounter = new Counter();
        if (!ParserRRX_SAX.allowedNodeElementURIs(namespaceURI, localName)) {
            throw this.RDFXMLparseError("Not allowed as a node element tag: '" + qName + "'", position);
        }
        if (!this.qNameMatches(rdfNS, rdfDescription, namespaceURI, localName)) {
            if (ParserRRX_SAX.isMemberProperty(namespaceURI, localName)) {
                this.RDFXMLparseWarning(qName + " is being used on a typed node", position);
            } else if (this.isNotRecognizedRDFtype(namespaceURI, localName)) {
                this.RDFXMLparseWarning(qName + " is not a recognized RDF term for a type", position);
            }
            Node object = this.qNameToIRI(namespaceURI, localName, QNameUsage.TypedNodeElement, position);
            this.emit(this.currentSubject, RDF.Nodes.type, object, position);
        }
        this.processPropertyAttributes(this.currentSubject, qName, attributes, false, position);
        this.parserMode(ParserMode.PropertyElement);
    }

    private void endNodeElement(Position position) {
        if (ReaderRDFXML_SAX.TRACE) {
            this.trace.println("endNodeElement. ParserMode = " + String.valueOf((Object)this.parserMode));
        }
    }

    private void startPropertyElement(String namespaceURI, String localName, String qName, Attributes attributes, Position position) {
        String dt;
        if (ReaderRDFXML_SAX.TRACE) {
            this.trace.printf("Start propertyElement: subject = %s\n", new Object[]{ParserRRX_SAX.str(this.currentSubject)});
        }
        if (!ParserRRX_SAX.allowedPropertyElementURIs(namespaceURI, localName)) {
            throw this.RDFXMLparseError("QName not allowed for property: " + qName, position);
        }
        if (this.isNotRecognizedRDFproperty(namespaceURI, localName)) {
            this.RDFXMLparseWarning(qName + " is not a recognized RDF property", position);
        }
        if (this.qNameMatches(rdfNS, rdfContainerItem, namespaceURI, localName)) {
            int i = this.containerPropertyCounter.value++;
            String p = "http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + i;
            this.currentProperty = this.iri(p, position);
        } else {
            this.currentProperty = this.qNameToIRI(namespaceURI, localName, QNameUsage.PropertyElement, position);
        }
        if (ReaderRDFXML_SAX.TRACE) {
            this.trace.printf("Property = %s\n", new Object[]{ParserRRX_SAX.str(this.currentProperty)});
        }
        this.datatype = (dt = attributes.getValue(rdfNS, rdfDatatype)) != null ? NodeFactory.getType((String)dt) : null;
        this.currentEmitter = this.maybeReifyStatement(attributes, position);
        String rdfResourceStr = attributes.getValue(rdfNS, rdfResource);
        String objBlankNodeLabel = attributes.getValue(rdfNS, rdfNodeID);
        String parseTypeStr = attributes.getValue(rdfNS, rdfParseType);
        Node resourceObj = null;
        if (dt != null) {
            if (parseTypeStr != null) {
                throw this.RDFXMLparseError("rdf:datatype can not be used with rdf:parseType.", position);
            }
            if (rdfResourceStr != null) {
                throw this.RDFXMLparseError("rdf:datatype can not be used with rdf:resource.", position);
            }
            if (objBlankNodeLabel != null) {
                throw this.RDFXMLparseError("rdf:datatype can not be used with rdf:NodeId.", position);
            }
        }
        if (rdfResourceStr != null && objBlankNodeLabel != null) {
            throw this.RDFXMLparseError("Both rdf:resource and rdf:NodeId on a property element. Only one allowed", position);
        }
        if (rdfResourceStr != null && parseTypeStr != null) {
            throw this.RDFXMLparseError("Both rdf:resource and rdf:ParseType on a property element. Only one allowed", position);
        }
        if (objBlankNodeLabel != null && parseTypeStr != null) {
            throw this.RDFXMLparseError("Both rdf:NodeId and rdf:ParseType on a property element. Only one allowed", position);
        }
        if (rdfResourceStr != null) {
            resourceObj = this.iriResolve(rdfResourceStr, position);
        }
        if (objBlankNodeLabel != null) {
            resourceObj = this.blankNode(objBlankNodeLabel, position);
        }
        Node innerSubject = this.processPropertyAttributes(resourceObj, qName, attributes, true, position);
        if (resourceObj == null && innerSubject != null) {
            this.currentEmitter.emit(this.currentSubject, this.currentProperty, innerSubject, position);
            return;
        }
        if (resourceObj != null) {
            this.currentEmitter.emit(this.currentSubject, this.currentProperty, resourceObj, position);
            return;
        }
        ObjectParseType objectParseType = this.objectParseType(parseTypeStr, position);
        switch (objectParseType) {
            case Plain: {
                this.parserMode(ParserMode.ObjectLex);
                this.accCharacters.setLength(0);
                break;
            }
            case Resource: {
                Node nested = this.blankNode(position);
                if (ReaderRDFXML_SAX.TRACE) {
                    this.trace.printf("Subject = %s\n", new Object[]{ParserRRX_SAX.str(nested)});
                }
                this.currentEmitter.emit(this.currentSubject, this.currentProperty, nested, position);
                this.currentProperty = null;
                this.currentSubject = nested;
                this.parserMode(ParserMode.ObjectParseTypeResource);
                this.pushParserFrame();
                this.parserMode(ParserMode.PropertyElement);
                break;
            }
            case Literal: {
                this.startXMLLiteral(position);
                break;
            }
            case Collection: {
                this.parserMode(ParserMode.ObjectParseTypeCollection);
                this.collectionNode = new NodeHolder();
            }
        }
    }

    private void endPropertyElement(Position position) {
        if (ReaderRDFXML_SAX.TRACE) {
            this.trace.println("endPropertyElement");
        }
    }

    private boolean isEndNodeElement() {
        return this.currentProperty == null;
    }

    private void startCollectionItem(String namespaceURI, String localName, String qName, Attributes attributes, Position position) {
        if (ReaderRDFXML_SAX.TRACE) {
            this.trace.println("Generate list cell");
        }
        Node previousCollectionNode = this.collectionNode.node;
        Node thisCollectionNode = this.blankNode(position);
        if (previousCollectionNode == null) {
            this.currentEmitter.emit(this.currentSubject, this.currentProperty, thisCollectionNode, position);
        } else {
            this.emit(previousCollectionNode, RDF.Nodes.rest, thisCollectionNode, position);
        }
        this.collectionNode.node = thisCollectionNode;
        Node itemSubject = this.attributesToSubjectNode(attributes, position);
        this.emit(thisCollectionNode, RDF.Nodes.first, itemSubject, position);
        this.startNodeElementWithSubject(itemSubject, namespaceURI, localName, qName, attributes, position);
    }

    private void endCollectionItem(Position position) {
        if (ReaderRDFXML_SAX.TRACE) {
            this.trace.println("endObjectCollectionItem");
        }
        if (this.collectionNode.node != null) {
            this.emit(this.collectionNode.node, RDF.Nodes.rest, RDF.Nodes.nil, position);
        } else {
            this.emit(this.currentSubject, this.currentProperty, RDF.Nodes.nil, position);
        }
    }

    private void endObjectLexical(Position position) {
        if (ReaderRDFXML_SAX.TRACE) {
            this.trace.println("endObjectLexical");
        }
        Node object = this.generateLiteral(position);
        this.currentEmitter.emit(this.currentSubject, this.currentProperty, object, position);
        this.accCharacters.setLength(0);
    }

    private void endObjectXMLLiteral(Position position) {
        if (ReaderRDFXML_SAX.TRACE) {
            this.trace.println("endObjectXMLLiteral");
        }
        Node object = this.generateXMLLiteral(position);
        this.currentEmitter.emit(this.currentSubject, this.currentProperty, object, position);
        this.namespaces = Map.of();
        this.stackNamespaces.clear();
        this.accCharacters.setLength(0);
    }

    private Node attributesToSubjectNode(Attributes attributes, Position position) {
        String iriStr = attributes.getValue(rdfNS, rdfAbout);
        String idStr = attributes.getValue(rdfNS, rdfID);
        String blankNodelabel = attributes.getValue(rdfNS, rdfNodeID);
        if (blankNodelabel != null && iriStr != null && blankNodelabel != null) {
            throw this.RDFXMLparseError("All of rdf:about, rdf:NodeId and rdf:ID found. Must be only one.", position);
        }
        if (iriStr != null && idStr != null) {
            throw this.RDFXMLparseError("Both rdf:about and rdf:ID found. Must be only one.", position);
        }
        if (blankNodelabel != null && iriStr != null) {
            throw this.RDFXMLparseError("Both rdf:about and rdf:NodeID found. Must be only one.", position);
        }
        if (blankNodelabel != null && idStr != null) {
            throw this.RDFXMLparseError("Both rdf:NodeID rdf:ID found. Must be only one.", position);
        }
        if (iriStr != null) {
            return this.iriResolve(iriStr, position);
        }
        if (idStr != null) {
            return this.iriFromID(idStr, position);
        }
        if (blankNodelabel != null) {
            return this.blankNode(blankNodelabel, position);
        }
        return this.blankNode(position);
    }

    private void processBaseAndLang(Attributes attributes, Position position) {
        IRIx xmlBase = this.xmlBase(attributes, position);
        String xmlLang = this.xmlLang(attributes, position);
        if (ReaderRDFXML_SAX.TRACE) {
            if (xmlBase != null) {
                this.trace.printf("+ BASE <%s>\n", new Object[]{xmlBase});
            }
            if (xmlLang != null) {
                this.trace.printf("+ LANG @%s\n", new Object[]{xmlLang});
            }
        }
        if (xmlBase != null && !xmlBase.equals((Object)this.currentBase)) {
            this.currentBase = xmlBase;
            this.updateCurrentIriCacheForCurrentBase();
        }
        if (xmlLang != null) {
            this.currentLang = xmlLang;
        }
    }

    private Node processPropertyAttributes(Node resourceObj, String qName, Attributes attributes, boolean isPropertyElement, Position position) {
        String parseTypeStr;
        List<Integer> indexes = this.gatherPropertyAttributes(attributes, position);
        if (indexes.isEmpty()) {
            return null;
        }
        if (isPropertyElement && (parseTypeStr = attributes.getValue(rdfNS, rdfParseType)) != null) {
            throw this.RDFXMLparseError("The attribute rdf:parseType is not permitted with property attributes on a property element: " + qName, position);
        }
        Node innerSubject = resourceObj == null ? this.blankNode(position) : resourceObj;
        this.outputPropertyAttributes(innerSubject, indexes, attributes, position);
        return innerSubject;
    }

    private List<Integer> gatherPropertyAttributes(Attributes attributes, Position position) {
        if (attributes.getLength() == 0) {
            return List.of();
        }
        ArrayList<Integer> attributeIdx = new ArrayList<Integer>(attributes.getLength());
        for (int idx = 0; idx < attributes.getLength(); ++idx) {
            boolean isPropertyAttribute = this.checkPropertyAttribute(attributes, idx, position);
            if (!isPropertyAttribute) continue;
            attributeIdx.add(idx);
        }
        return attributeIdx;
    }

    private void outputPropertyAttributes(Node subject, List<Integer> indexes, Attributes attributes, Position position) {
        for (int index : indexes) {
            String namespaceURI = attributes.getURI(index);
            String localName = attributes.getLocalName(index);
            String value = attributes.getValue(index);
            if (rdfNS.equals(namespaceURI) && rdfType.equals(localName)) {
                Node type = this.iriResolve(value, position);
                this.emit(subject, RDF.Nodes.type, type, position);
                return;
            }
            Node property = this.attributeToIRI(namespaceURI, localName, position);
            String lex = value;
            Node object = this.literal(lex, this.currentLang, position);
            this.emit(subject, property, object, position);
        }
    }

    private boolean checkPropertyAttribute(Attributes attributes, int index, Position position) {
        String namespaceURI = attributes.getURI(index);
        String localName = attributes.getLocalName(index);
        String qName = attributes.getQName(index);
        if (ParserRRX_SAX.isSyntaxAttribute(namespaceURI, localName)) {
            return false;
        }
        if (this.coreSyntaxTerm(namespaceURI, localName)) {
            return false;
        }
        if (!ParserRRX_SAX.allowedPropertyAttributeURIs(namespaceURI, localName)) {
            throw this.RDFXMLparseError("Not allowed as a property attribute '" + attributes.getQName(index) + "'", position);
        }
        if (this.isNotRecognizedRDFproperty(namespaceURI, localName)) {
            this.RDFXMLparseWarning(qName + " is not a recognized RDF term for a property attribute", position);
        }
        if (ParserRRX_SAX.isXMLQName(namespaceURI, localName)) {
            return false;
        }
        if (ParserRRX_SAX.isXMLNamespace(namespaceURI)) {
            this.RDFXMLparseWarning("Unrecognized XML attribute '" + qName + "' - ignored", position);
            return false;
        }
        if (ParserRRX_SAX.isXMLNamespaceQName(qName)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)namespaceURI)) {
            boolean valid = this.checkPropertyAttributeUnqualifiedTerm(localName, position);
            return valid;
        }
        return true;
    }

    private boolean checkPropertyAttributeUnqualifiedTerm(String localName, Position position) {
        String chars3;
        if (ParserRRX_SAX.allowedUnqualifiedTerm(localName)) {
            return true;
        }
        if (localName.length() >= 3 && (chars3 = localName.substring(0, 3)).equalsIgnoreCase("xml")) {
            this.RDFXMLparseWarning("Unrecognized XML non-namespaced attribute '" + localName + "' - ignored", position);
            return false;
        }
        throw this.RDFXMLparseError("Non-namespaced attribute not allowed as a property attribute: '" + localName + "'", position);
    }

    private IRIx xmlBase(Attributes attributes, Position position) {
        String baseStr = attributes.getValue(xmlNS, xmlBaseLN);
        if (baseStr == null) {
            return null;
        }
        IRIx irix = this.resolveIRIxAny(baseStr, position);
        if (irix.isRelative()) {
            this.RDFXMLparseWarning("Relative URI for base: <" + baseStr + ">", position);
        }
        return irix;
    }

    private String xmlLang(Attributes attributes, Position position) {
        String langStr = attributes.getValue(xmlNS, xmlLangLN);
        if (langStr == null) {
            return null;
        }
        return langStr;
    }

    private ObjectParseType objectParseType(String parseTypeStr, Position position) {
        if (parseTypeStr == null) {
            return ObjectParseType.Plain;
        }
        try {
            return ObjectParseType.valueOf(switch (parseTypeName = parseTypeStr) {
                case "literal" -> {
                    this.RDFXMLparseWarning("Encountered rdf:parseType='literal'. Treated as rdf:parseType='Literal'", position);
                    yield "Literal";
                }
                case "Statements" -> {
                    this.RDFXMLparseWarning("Encountered rdf:parseType='Statements'. Treated as rdf:parseType='Literal'", position);
                    yield "Literal";
                }
            });
        }
        catch (IllegalArgumentException ex) {
            throw this.RDFXMLparseError("Not a legal value for rdf:parseType: '" + parseTypeStr + "'", position);
        }
    }

    private Emitter maybeReifyStatement(Attributes attributes, Position position) {
        String reifyId = attributes.getValue(rdfNS, rdfID);
        if (reifyId == null) {
            return this::emit;
        }
        Node reify = this.iriFromID(reifyId, position);
        return (s, p, o, loc) -> this.emitReify(reify, s, p, o, loc);
    }

    private Node generateLiteral(Position position) {
        String lex = this.accCharacters.toString();
        if (this.datatype != null) {
            return this.literalDatatype(lex, this.datatype, position);
        }
        return this.literal(lex, this.currentLang, position);
    }

    private Node generateXMLLiteral(Position position) {
        String lex = this.xmlLiteralCollectText();
        return this.literalDatatype(lex, rdfXmlLiteralDT, position);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (EVENTS) {
            this.traceXML.println("setDocumentLocator");
        }
        this.locator = locator;
    }

    private Position position() {
        return new Position(this.locator.getLineNumber(), this.locator.getColumnNumber());
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (ReaderRDFXML_SAX.TRACE) {
            this.trace.printf("startPrefixMapping: %s: <%s>\n", new Object[]{prefix, uri});
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (ReaderRDFXML_SAX.TRACE) {
            this.trace.printf("endPrefixMapping: %s\n", new Object[]{prefix});
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.xmlLiteralCollecting()) {
            this.xmlLiteralCollectCharacters(ch, start, length);
            return;
        }
        switch (this.parserMode) {
            case ObjectLex: {
                this.accCharacters.append(ch, start, length);
                return;
            }
            case ObjectParseTypeLiteral: {
                return;
            }
            case ObjectNode: 
            case NodeElement: 
            case PropertyElement: 
            case ObjectParseTypeCollection: 
            case ObjectParseTypeResource: {
                if (ParserRRX_SAX.isWhitespace(ch, start, length)) break;
                String text = ParserRRX_SAX.nonWhitespaceMsg(ch, start, length);
                throw this.RDFXMLparseError("Non-whitespace text content between element tags: '" + text + "'", this.position());
            }
            case TOP: {
                if (ParserRRX_SAX.isWhitespace(ch, start, length)) break;
                String text = ParserRRX_SAX.nonWhitespaceMsg(ch, start, length);
                throw this.RDFXMLparseError("Non-whitespace text content outside element tags: '" + text + "'", this.position());
            }
        }
    }

    private static String nonWhitespaceMsg(char[] ch, int start, int length) {
        int MaxLen = 10;
        for (int i = start; i < start + length; ++i) {
            if (Character.isWhitespace(ch[i])) continue;
            int remaindingLength = length - (i - start);
            int len = Math.min(10, remaindingLength);
            Object x = new String(ch, i, len);
            if (remaindingLength > 10) {
                x = (String)x + "...";
            }
            x = EscapeStr.stringEsc((String)x);
            x = ((String)x).stripTrailing();
            return x;
        }
        throw new RDFXMLParseException("Internal error: Failed to find any non-whitespace characters");
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (ReaderRDFXML_SAX.TRACE) {
            this.traceXML.println("ignorableWhitespace");
        }
    }

    private static boolean isWhitespace(char[] ch, int start, int length) {
        for (int i = start; i < start + length; ++i) {
            char ich = ch[i];
            if (Character.isWhitespace(ich)) continue;
            return false;
        }
        return true;
    }

    private static boolean isWhitespace(CharSequence chars) {
        for (int i = 0; i < chars.length(); ++i) {
            char ich = chars.charAt(i);
            if (ParserRRX_SAX.isWhitespace(ich)) continue;
            return false;
        }
        return true;
    }

    private static boolean isWhitespace(char ch) {
        return Character.isWhitespace(ch);
    }

    private String here() {
        Position position = this.position();
        if (position == null) {
            return "[?, ?]";
        }
        return String.format("[line:%d, col:%d]", position.line(), position.column());
    }

    private void emit(Node subject, Node property, Node object, Position position) {
        Objects.requireNonNull(subject, "subject");
        Objects.requireNonNull(property, "property");
        Objects.requireNonNull(object, "object");
        Objects.requireNonNull(position, "position");
        this.destination.triple(Triple.create((Node)subject, (Node)property, (Node)object));
    }

    private void emitReify(Node reify, Node subject, Node property, Node object, Position position) {
        this.emit(subject, property, object, position);
        if (reify != null) {
            this.emit(reify, RDF.Nodes.type, RDF.Nodes.Statement, position);
            this.emit(reify, RDF.Nodes.subject, subject, position);
            this.emit(reify, RDF.Nodes.predicate, property, position);
            this.emit(reify, RDF.Nodes.object, object, position);
        }
    }

    private void emitBase(String base, Position position) {
        this.destination.base(base);
    }

    private void emitPrefix(String prefix, String iriStr, Position position) {
        this.destination.prefix(prefix, iriStr);
    }

    private Node qNameToIRI(String namespaceURI, String localName, QNameUsage usage, Position position) {
        if (StringUtils.isBlank((CharSequence)namespaceURI)) {
            throw this.RDFXMLparseError("Unqualified " + usage.msg + " not allowed: <" + localName + ">", position);
        }
        String uriStr = this.strQNameToIRI(namespaceURI, localName);
        return this.iri(uriStr, position);
    }

    private String strQNameToIRI(String namespaceURI, String localName) {
        String iriStr = namespaceURI + localName;
        return iriStr;
    }

    private Node attributeToIRI(String namespaceURI, String localName, Position position) {
        String ns = namespaceURI;
        if (StringUtils.isBlank((CharSequence)namespaceURI)) {
            if (ParserRRX_SAX.allowedUnqualifiedTerm(localName)) {
                ns = rdfNS;
            } else {
                throw this.RDFXMLparseError("Unqualified property attribute not allowed: '" + localName + "'", position);
            }
        }
        String uriStr = this.strQNameToIRI(namespaceURI, localName);
        return this.iri(uriStr, position);
    }

    private Node iri(String uriStr, Position position) {
        Objects.requireNonNull(uriStr);
        Objects.requireNonNull(position);
        return this.createURI(uriStr, position);
    }

    private Node iriFromID(String idStr, Position position) {
        this.checkValidNCName(idStr, position);
        Position prev = this.previousUseOfID(idStr, position);
        if (prev != null) {
            this.RDFXMLparseWarning("Reuse of rdf:ID '" + idStr + "' at " + ParserRRX_SAX.str(prev), position);
        }
        Node uri = this.iriResolve("#" + idStr, position);
        return uri;
    }

    private Node iriResolve(String uriStr, Position position) {
        Objects.requireNonNull(uriStr);
        Objects.requireNonNull(position);
        return uriStr.startsWith("_:") ? this.createURI(uriStr, position) : this.createURI(this.resolveIRIx(uriStr, position), position);
    }

    private IRIx resolveIRIx(String uriStr, Position position) {
        try {
            IRIx iri = this.resolveIRIxAny(uriStr, position);
            if (iri.isRelative()) {
                throw this.RDFXMLparseError("Relative URI encountered: <" + iri.str() + ">", position);
            }
            return iri;
        }
        catch (IRIException ex) {
            throw this.RDFXMLparseError(ex.getMessage(), position);
        }
    }

    private IRIx resolveIRIxAny(String uriStr, Position position) {
        try {
            return (IRIx)this.currentIriCache.get((Object)uriStr, uri -> {
                if (this.currentBase != null) {
                    return this.currentBase.resolve(uri);
                }
                return IRIx.create((String)uriStr);
            });
        }
        catch (IRIException ex) {
            throw this.RDFXMLparseError(ex.getMessage(), position);
        }
    }

    private Node createURI(String iriStr, Position position) {
        int line = position.line();
        int col = position.column();
        return this.parserProfile.createURI(iriStr, (long)line, (long)col);
    }

    private Node createURI(IRIx iriX, Position position) {
        int line = position.line();
        int col = position.column();
        return this.parserProfile.createURI(iriX, (long)line, (long)col);
    }

    private Node blankNode(Position position) {
        Objects.requireNonNull(position);
        int line = position.line();
        int col = position.column();
        return this.parserProfile.createBlankNode(null, line, col);
    }

    private void checkValidNCName(String string, Position position) {
        boolean isValid = XML11Char.isXML11ValidNCName((String)string);
        if (!isValid) {
            this.RDFXMLparseWarning("Not a valid XML NCName: '" + string + "'", position);
        }
    }

    private static boolean isRDF(String namespaceURI) {
        return rdfNS.equals(namespaceURI);
    }

    private static boolean isMemberProperty(String namespaceURI, String localName) {
        if (!ParserRRX_SAX.isRDF(namespaceURI)) {
            return false;
        }
        return ParserRRX_SAX.isMemberPropertyLocalName(localName);
    }

    private static boolean isMemberPropertyLocalName(String localName) {
        if (localName.startsWith("_")) {
            String number = localName.substring(1);
            if (number.startsWith("-") || number.startsWith("0")) {
                return false;
            }
            try {
                Integer.parseInt(number);
                return true;
            }
            catch (NumberFormatException e2) {
                try {
                    BigInteger i = new BigInteger(number);
                    return true;
                }
                catch (NumberFormatException ee) {
                    return false;
                }
            }
        }
        return false;
    }

    private boolean isNotRecognizedRDFtype(String namespaceURI, String localName) {
        if (!ParserRRX_SAX.isRDF(namespaceURI)) {
            return false;
        }
        return !knownRDFTypes.contains(localName);
    }

    private boolean isNotRecognizedRDFproperty(String namespaceURI, String localName) {
        if (!ParserRRX_SAX.isRDF(namespaceURI)) {
            return false;
        }
        if (ParserRRX_SAX.isMemberPropertyLocalName(localName)) {
            return false;
        }
        return !knownRDFProperties.contains(localName);
    }

    private Node blankNode(String label, Position position) {
        Objects.requireNonNull(label);
        Objects.requireNonNull(position);
        this.checkValidNCName(label, position);
        int line = position.line();
        int col = position.column();
        return this.parserProfile.createBlankNode(null, label, line, col);
    }

    private Node literal(String lexical, Position position) {
        Objects.requireNonNull(lexical);
        Objects.requireNonNull(position);
        int line = position.line();
        int col = position.column();
        return this.parserProfile.createStringLiteral(lexical, line, col);
    }

    private Node literal(String lexical, String lang, Position position) {
        if (lang == null || lang.isEmpty()) {
            return this.literal(lexical, position);
        }
        Objects.requireNonNull(lexical);
        Objects.requireNonNull(position);
        int line = position.line();
        int col = position.column();
        return this.parserProfile.createLangLiteral(lexical, lang, line, col);
    }

    private Node literalDatatype(String lexical, String datatype, Position position) {
        Objects.requireNonNull(lexical);
        Objects.requireNonNull(datatype);
        Objects.requireNonNull(position);
        int line = position.line();
        int col = position.column();
        RDFDatatype dt = NodeFactory.getType((String)datatype);
        return this.parserProfile.createTypedLiteral(lexical, dt, line, col);
    }

    private Node literalDatatype(String lexical, RDFDatatype datatype, Position position) {
        Objects.requireNonNull(lexical);
        Objects.requireNonNull(datatype);
        Objects.requireNonNull(position);
        int line = position.line();
        int col = position.column();
        return this.parserProfile.createTypedLiteral(lexical, datatype, line, col);
    }

    private boolean qNameMatches(String ns1, String local1, String ns2, String local2) {
        return Objects.equals(ns1, ns2) && Objects.equals(local1, local2);
    }

    private void incIndent() {
        if (ReaderRDFXML_SAX.TRACE) {
            this.trace.incIndent();
        }
    }

    private void decIndent() {
        if (ReaderRDFXML_SAX.TRACE) {
            this.trace.decIndent();
        }
    }

    private void startXMLLiteral(Position position) {
        if (ReaderRDFXML_SAX.TRACE) {
            this.trace.printf("Start XML Literal : depth=%d\n", new Object[]{this.elementDepth});
        }
        this.incIndent();
        this.parserMode(ParserMode.ObjectParseTypeLiteral);
        this.xmlLiteralStartDepth = this.elementDepth;
        this.accCharacters.setLength(0);
    }

    private void endXMLLiteral(Position position) {
        this.decIndent();
        if (ReaderRDFXML_SAX.TRACE) {
            this.trace.printf("End XML Literal : depth=%d\n", new Object[]{this.elementDepth});
        }
        this.xmlLiteralStartDepth = -1;
    }

    private String xmlLiteralCollectText() {
        String lexical = this.xmlEscapeStrText(this.accCharacters);
        return lexical;
    }

    private boolean xmlLiteralCollecting() {
        return this.xmlLiteralStartDepth > 0;
    }

    private String xmlEscapeStrText(CharSequence stringAcc) {
        return stringAcc.toString();
    }

    private void xmlLiteralCollectStartElement(String namespaceURI, String localName, String qName, Attributes attributes) {
        if (ReaderRDFXML_SAX.TRACE) {
            this.trace.printf("XML Literal[%s]: depth=%d\n", new Object[]{qName, this.elementDepth});
        }
        this.incIndent();
        this.incElementDepth();
        this.stackNamespaces.push(this.namespaces);
        this.namespaces = new HashMap<String, String>(this.namespaces);
        TreeMap<String, String> outputNS = new TreeMap<String, String>();
        this.accCharacters.append(openStartTag);
        this.accCharacters.append(qName);
        this.xmlLiteralNamespaces(outputNS, namespaceURI, localName, qName, attributes);
        this.xmlLiteralAttributes(attributes);
        this.accCharacters.append(">");
    }

    private void xmlLiteralNamespaces(Map<String, String> outputNS, String namespaceURI, String localName, String qName, Attributes attributes) {
        this.xmlLiteralNamespacesForQName(outputNS, namespaceURI, localName, qName);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attrQName = attributes.getQName(i);
            String u = attributes.getURI(i);
            if (u.isEmpty() || attrQName.equals("xmlns") || attrQName.startsWith("xmlns:")) continue;
            this.xmlLiteralNamespacesForQName(outputNS, attributes.getURI(i), attributes.getLocalName(i), attrQName);
        }
        for (String prefix : outputNS.keySet()) {
            String uri = outputNS.get(prefix);
            if (uri.isEmpty()) continue;
            this.accCharacters.append(" ");
            this.accCharacters.append(prefix);
            this.accCharacters.append("=\"");
            this.accCharacters.append(uri);
            this.accCharacters.append("\"");
        }
    }

    private void xmlLiteralNamespaceQName(Map<String, String> outputNS, Map<String, String> namespaces, NamespaceContext nsCxt, QName qName) {
        String prefix = qName.getPrefix();
        String namespaceURI = nsCxt.getNamespaceURI(prefix);
        if (!namespaces.containsKey(prefix) || !namespaces.get(prefix).equals(namespaceURI)) {
            outputNS.put(prefix, namespaceURI);
            namespaces.put(prefix, namespaceURI);
        }
    }

    private void xmlLiteralAttributes(Attributes attributes) {
        TreeMap<String, Integer> attrs = new TreeMap<String, Integer>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attrQName = attributes.getQName(i);
            if (attrQName.equals("xmlns") || attrQName.startsWith("xmlns:")) continue;
            attrs.put(attrQName, i);
        }
        Iterator iterAttr = attrs.values().iterator();
        while (iterAttr.hasNext()) {
            int idx = (Integer)iterAttr.next();
            String name = attributes.getQName(idx);
            String value = attributes.getValue(idx);
            this.accCharacters.append(" ");
            this.accCharacters.append(name);
            this.accCharacters.append("=\"");
            this.accCharacters.append(this.xmlLiteralEscapeAttr(value));
            this.accCharacters.append("\"");
        }
    }

    private void xmlLiteralCollectEndElement(String namespaceURI, String localName, String qName) {
        this.accCharacters.append(openEndTag);
        this.accCharacters.append(qName);
        this.accCharacters.append(">");
        this.namespaces = this.stackNamespaces.pop();
        this.decElementDepth();
        this.decIndent();
        if (ReaderRDFXML_SAX.TRACE) {
            this.trace.printf("XML Literal[/%s]: depth=%d\n", new Object[]{qName, this.elementDepth});
        }
    }

    private void xmlLiteralCollectCharacters(char[] ch, int start, int length) {
        if (ReaderRDFXML_SAX.TRACE) {
            this.trace.printf("XML Literal Characters: depth=%d\n", new Object[]{this.elementDepth});
        }
        String s = new String(ch, start, length);
        s = this.xmlLiteralEscapeText(s);
        this.accCharacters.append(s);
    }

    private void xmlLiteralNamespacesForQName(Map<String, String> outputNS, String namespaceURI, String localName, String qName) {
        int idx = qName.indexOf(58);
        Object nsAttr = idx < 1 ? "xmlns" : "xmlns:" + qName.substring(0, idx);
        if (!this.namespaces.containsKey(nsAttr) || !this.namespaces.get(nsAttr).equals(namespaceURI)) {
            this.namespaces.put((String)nsAttr, namespaceURI);
            outputNS.put((String)nsAttr, namespaceURI);
        }
    }

    private String xmlLiteralEscapeText(CharSequence stringAcc) {
        StringBuilder sBuff = new StringBuilder();
        int len = stringAcc.length();
        for (int i = 0; i < len; ++i) {
            String replace;
            char c = stringAcc.charAt(i);
            switch (c) {
                case '&': {
                    String string = "&amp;";
                    break;
                }
                case '<': {
                    String string = "&lt;";
                    break;
                }
                case '>': {
                    String string = "&gt;";
                    break;
                }
                default: {
                    String string = replace = null;
                }
            }
            if (replace == null) {
                sBuff.append(c);
                continue;
            }
            sBuff.append(replace);
        }
        return sBuff.toString();
    }

    private String xmlLiteralEscapeAttr(CharSequence stringAcc) {
        StringBuilder sBuff = new StringBuilder();
        int len = stringAcc.length();
        for (int i = 0; i < len; ++i) {
            String replace;
            char c = stringAcc.charAt(i);
            switch (c) {
                case '&': {
                    String string = "&amp;";
                    break;
                }
                case '<': {
                    String string = "&lt;";
                    break;
                }
                case '\"': {
                    String string = "&quot;";
                    break;
                }
                default: {
                    String string = replace = null;
                }
            }
            if (replace == null) {
                sBuff.append(c);
                continue;
            }
            sBuff.append(replace);
        }
        return sBuff.toString();
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.xmlLiteralCollecting()) {
            this.accCharacters.append("<?");
            this.accCharacters.append(target);
            this.accCharacters.append(' ');
            this.accCharacters.append(data);
            this.accCharacters.append("?>");
            return;
        }
        if (EVENTS) {
            this.traceXML.println("processingInstruction");
        }
        this.RDFXMLparseWarning("XML Processing instruction - ignored", this.position());
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (EVENTS) {
            this.traceXML.println("skippedEntity");
        }
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        if (EVENTS) {
            this.traceXML.println("warning");
        }
        this.errorHandler.warning(exception.getMessage(), exception.getLineNumber(), exception.getColumnNumber());
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        if (EVENTS) {
            this.traceXML.println("error");
        }
        this.errorHandler.fatal(exception.getMessage(), exception.getLineNumber(), exception.getColumnNumber());
        throw exception;
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        if (EVENTS) {
            this.traceXML.println("fatalError");
        }
        this.errorHandler.fatal(exception.getMessage(), exception.getLineNumber(), exception.getColumnNumber());
        throw exception;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (EVENTS) {
            this.traceXML.println("resolveEntity");
        }
        return null;
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        if (EVENTS) {
            this.traceXML.println("SAX2-resolveEntity");
        }
        return null;
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (EVENTS) {
            this.traceXML.println("notationDecl");
        }
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if (EVENTS) {
            this.traceXML.println("unparsedEntityDecl");
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (EVENTS) {
            this.traceXML.println("SAX2-startDTD: " + systemId);
        }
    }

    @Override
    public void endDTD() throws SAXException {
        if (EVENTS) {
            this.traceXML.println("SAX2-endDTD");
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (EVENTS) {
            this.traceXML.println("SAX2-startEntity");
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (EVENTS) {
            this.traceXML.println("SAX2-endEntity");
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (EVENTS) {
            this.traceXML.println("SAX2-startCDATA");
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (EVENTS) {
            this.traceXML.println("SAX2-endCDATA");
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.xmlLiteralCollecting()) {
            this.accCharacters.append("<!--");
            this.accCharacters.append(ch, start, length);
            this.accCharacters.append("-->");
            return;
        }
        if (EVENTS) {
            this.traceXML.println("SAX2-comment");
        }
    }

    @Override
    public void elementDecl(String name, String model) throws SAXException {
        if (EVENTS) {
            this.traceXML.println("SAX2-elementDecl");
        }
    }

    @Override
    public void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
        if (EVENTS) {
            this.traceXML.println("SAX2-attributeDecl");
        }
    }

    @Override
    public void internalEntityDecl(String name, String value) throws SAXException {
        if (EVENTS) {
            this.traceXML.println("SAX2-internalEntityDecl");
        }
    }

    @Override
    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        if (EVENTS) {
            this.traceXML.println("SAX2-externalEntityDecl");
        }
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        if (EVENTS) {
            this.traceXML.println("SAX2-getExternalSubset");
        }
        return null;
    }

    private record Position(int line, int column) {
    }

    private static enum ParserMode {
        TOP,
        NodeElement,
        PropertyElement,
        ObjectLex,
        ObjectParseTypeResource,
        ObjectParseTypeLiteral,
        ObjectParseTypeCollection,
        ObjectNode;

    }

    private record ParserFrame(IRIx base, String lang, Node subject, Node property, Counter containerPropertyCounter, NodeHolder collectionNode, Emitter emitter, ParserMode parserMode, Cache<String, IRIx> iriCache) {
    }

    private static class Counter {
        int value = 1;

        private Counter() {
        }
    }

    private static class NodeHolder {
        Node node = null;

        private NodeHolder() {
        }
    }

    static interface Emitter {
        public void emit(Node var1, Node var2, Node var3, Position var4);
    }

    private static enum QNameUsage {
        TypedNodeElement("typed node element"),
        PropertyElement("property element");

        final String msg;

        private QNameUsage(String msg) {
            this.msg = msg;
        }
    }

    private static enum ObjectParseType {
        Literal,
        Collection,
        Resource,
        Plain;

    }
}

