#!/bin/bash

# install directory is directory of given script by default
if [ -z "${SEMSPECT_HOME}" ]; then
    SEMSPECT_HOME=$(cd -- "$(dirname -- "${BASH_SOURCE[0]}")" &>/dev/null && pwd)
fi
source "$SEMSPECT_HOME/java-settings.sh"
MAIN_CLASS="de.derivo.semspect.server.view.rest.SemSpectServer"

echo "==="
echo "Starting SemSpect with configuration:"
echo "Java command path: $SEMSPECT_JAVA_PATH"
echo "Java class path: $CLASS_PATH"
echo "JDK options: $JDK_OPTIONS"
echo "==="

# 3 ways to specify parameters:
# - Define parameters using application arguments '--semspect.rdf.mode=generate'
# - Use an external configuration file with the application argument '--spring.config.additional-location="path/to/config.yaml"' (.yaml or .properties, cf. example)
# - Define parameters using JVM arguments '-Dsemspect.rdf.mode=generate'
$JAVA_PATH $JDK_OPTIONS -cp "$CLASS_PATH" "$MAIN_CLASS" "$@"
